<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicantAddress StructType
 * @subpackage Structs
 */
class ApplicantAddress extends Address
{
    /**
     * The AddressTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressTypeId;
    /**
     * The MonthsAtAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MonthsAtAddress;
    /**
     * The ResidentialStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ResidentialStatusId;
    /**
     * The RentPaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RentPaymentAmount;
    /**
     * Constructor method for ApplicantAddress
     * @uses ApplicantAddress::setAddressTypeId()
     * @uses ApplicantAddress::setMonthsAtAddress()
     * @uses ApplicantAddress::setResidentialStatusId()
     * @uses ApplicantAddress::setRentPaymentAmount()
     * @param string $addressTypeId
     * @param int $monthsAtAddress
     * @param string $residentialStatusId
     * @param float $rentPaymentAmount
     */
    public function __construct($addressTypeId = null, $monthsAtAddress = null, $residentialStatusId = null, $rentPaymentAmount = null)
    {
        $this
            ->setAddressTypeId($addressTypeId)
            ->setMonthsAtAddress($monthsAtAddress)
            ->setResidentialStatusId($residentialStatusId)
            ->setRentPaymentAmount($rentPaymentAmount);
    }
    /**
     * Get AddressTypeId value
     * @return string
     */
    public function getAddressTypeId()
    {
        return $this->AddressTypeId;
    }
    /**
     * Set AddressTypeId value
     * @uses \TurnedAwayBOSS\EnumType\AddressType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypeId
     * @return \TurnedAwayBOSS\StructType\ApplicantAddress
     */
    public function setAddressTypeId($addressTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\AddressType::valueIsValid($addressTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\AddressType', is_array($addressTypeId) ? implode(', ', $addressTypeId) : var_export($addressTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->AddressTypeId = $addressTypeId;
        return $this;
    }
    /**
     * Get MonthsAtAddress value
     * @return int
     */
    public function getMonthsAtAddress()
    {
        return $this->MonthsAtAddress;
    }
    /**
     * Set MonthsAtAddress value
     * @param int $monthsAtAddress
     * @return \TurnedAwayBOSS\StructType\ApplicantAddress
     */
    public function setMonthsAtAddress($monthsAtAddress = null)
    {
        // validation for constraint: int
        if (!is_null($monthsAtAddress) && !(is_int($monthsAtAddress) || ctype_digit($monthsAtAddress))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthsAtAddress, true), gettype($monthsAtAddress)), __LINE__);
        }
        $this->MonthsAtAddress = $monthsAtAddress;
        return $this;
    }
    /**
     * Get ResidentialStatusId value
     * @return string
     */
    public function getResidentialStatusId()
    {
        return $this->ResidentialStatusId;
    }
    /**
     * Set ResidentialStatusId value
     * @uses \TurnedAwayBOSS\EnumType\ResidentialStatus::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ResidentialStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $residentialStatusId
     * @return \TurnedAwayBOSS\StructType\ApplicantAddress
     */
    public function setResidentialStatusId($residentialStatusId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ResidentialStatus::valueIsValid($residentialStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ResidentialStatus', is_array($residentialStatusId) ? implode(', ', $residentialStatusId) : var_export($residentialStatusId, true), implode(', ', \TurnedAwayBOSS\EnumType\ResidentialStatus::getValidValues())), __LINE__);
        }
        $this->ResidentialStatusId = $residentialStatusId;
        return $this;
    }
    /**
     * Get RentPaymentAmount value
     * @return float
     */
    public function getRentPaymentAmount()
    {
        return $this->RentPaymentAmount;
    }
    /**
     * Set RentPaymentAmount value
     * @param float $rentPaymentAmount
     * @return \TurnedAwayBOSS\StructType\ApplicantAddress
     */
    public function setRentPaymentAmount($rentPaymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($rentPaymentAmount) && !(is_float($rentPaymentAmount) || is_numeric($rentPaymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rentPaymentAmount, true), gettype($rentPaymentAmount)), __LINE__);
        }
        $this->RentPaymentAmount = $rentPaymentAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\ApplicantAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
