<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant StructType
 * @subpackage Structs
 */
class Applicant extends AbstractStructBase
{
    /**
     * The ApplicantTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApplicantTypeId;
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Authentication;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The LanguagePreferenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LanguagePreferenceId;
    /**
     * The MartialStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MartialStatusId;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The RelationshipToMainApplicant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RelationshipToMainApplicant;
    /**
     * The IsResident
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsResident;
    /**
     * The ResidentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ResidentTypeId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Name
     */
    public $Name;
    /**
     * The NumberOfDependents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfDependents;
    /**
     * The PrefferedContactMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PrefferedContactMethodId;
    /**
     * The SocialInsuranceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SocialInsuranceNumber;
    /**
     * The BankruptcyStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BankruptcyStatusId;
    /**
     * The ExistingClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExistingClient;
    /**
     * The IsFirstTimeBuyer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsFirstTimeBuyer;
    /**
     * The ApplicantPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfPhone
     */
    public $ApplicantPhones;
    /**
     * The Identifications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfIdentification
     */
    public $Identifications;
    /**
     * The ApplicantAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress
     */
    public $ApplicantAddresses;
    /**
     * The Employments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfEmployment
     */
    public $Employments;
    /**
     * The Assets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfAsset
     */
    public $Assets;
    /**
     * The Liabilities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfLiability
     */
    public $Liabilities;
    /**
     * The Bankruptcies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy
     */
    public $Bankruptcies;
    /**
     * The OtherIncomes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome
     */
    public $OtherIncomes;
    /**
     * The OtherProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty
     */
    public $OtherProperties;
    /**
     * Constructor method for Applicant
     * @uses Applicant::setApplicantTypeId()
     * @uses Applicant::setAuthentication()
     * @uses Applicant::setBirthDate()
     * @uses Applicant::setEmailAddress()
     * @uses Applicant::setLanguagePreferenceId()
     * @uses Applicant::setMartialStatusId()
     * @uses Applicant::setGender()
     * @uses Applicant::setRelationshipToMainApplicant()
     * @uses Applicant::setIsResident()
     * @uses Applicant::setResidentTypeId()
     * @uses Applicant::setName()
     * @uses Applicant::setNumberOfDependents()
     * @uses Applicant::setPrefferedContactMethodId()
     * @uses Applicant::setSocialInsuranceNumber()
     * @uses Applicant::setBankruptcyStatusId()
     * @uses Applicant::setExistingClient()
     * @uses Applicant::setIsFirstTimeBuyer()
     * @uses Applicant::setApplicantPhones()
     * @uses Applicant::setIdentifications()
     * @uses Applicant::setApplicantAddresses()
     * @uses Applicant::setEmployments()
     * @uses Applicant::setAssets()
     * @uses Applicant::setLiabilities()
     * @uses Applicant::setBankruptcies()
     * @uses Applicant::setOtherIncomes()
     * @uses Applicant::setOtherProperties()
     * @param string $applicantTypeId
     * @param string $authentication
     * @param string $birthDate
     * @param string $emailAddress
     * @param string $languagePreferenceId
     * @param string $martialStatusId
     * @param string $gender
     * @param string $relationshipToMainApplicant
     * @param bool $isResident
     * @param string $residentTypeId
     * @param \TurnedAwayBOSS\StructType\Name $name
     * @param int $numberOfDependents
     * @param string $prefferedContactMethodId
     * @param string $socialInsuranceNumber
     * @param string $bankruptcyStatusId
     * @param bool $existingClient
     * @param bool $isFirstTimeBuyer
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfPhone $applicantPhones
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfIdentification $identifications
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress $applicantAddresses
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfEmployment $employments
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfAsset $assets
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfLiability $liabilities
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy $bankruptcies
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome $otherIncomes
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty $otherProperties
     */
    public function __construct($applicantTypeId = null, $authentication = null, $birthDate = null, $emailAddress = null, $languagePreferenceId = null, $martialStatusId = null, $gender = null, $relationshipToMainApplicant = null, $isResident = null, $residentTypeId = null, \TurnedAwayBOSS\StructType\Name $name = null, $numberOfDependents = null, $prefferedContactMethodId = null, $socialInsuranceNumber = null, $bankruptcyStatusId = null, $existingClient = null, $isFirstTimeBuyer = null, \TurnedAwayBOSS\ArrayType\ArrayOfPhone $applicantPhones = null, \TurnedAwayBOSS\ArrayType\ArrayOfIdentification $identifications = null, \TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress $applicantAddresses = null, \TurnedAwayBOSS\ArrayType\ArrayOfEmployment $employments = null, \TurnedAwayBOSS\ArrayType\ArrayOfAsset $assets = null, \TurnedAwayBOSS\ArrayType\ArrayOfLiability $liabilities = null, \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy $bankruptcies = null, \TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome $otherIncomes = null, \TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty $otherProperties = null)
    {
        $this
            ->setApplicantTypeId($applicantTypeId)
            ->setAuthentication($authentication)
            ->setBirthDate($birthDate)
            ->setEmailAddress($emailAddress)
            ->setLanguagePreferenceId($languagePreferenceId)
            ->setMartialStatusId($martialStatusId)
            ->setGender($gender)
            ->setRelationshipToMainApplicant($relationshipToMainApplicant)
            ->setIsResident($isResident)
            ->setResidentTypeId($residentTypeId)
            ->setName($name)
            ->setNumberOfDependents($numberOfDependents)
            ->setPrefferedContactMethodId($prefferedContactMethodId)
            ->setSocialInsuranceNumber($socialInsuranceNumber)
            ->setBankruptcyStatusId($bankruptcyStatusId)
            ->setExistingClient($existingClient)
            ->setIsFirstTimeBuyer($isFirstTimeBuyer)
            ->setApplicantPhones($applicantPhones)
            ->setIdentifications($identifications)
            ->setApplicantAddresses($applicantAddresses)
            ->setEmployments($employments)
            ->setAssets($assets)
            ->setLiabilities($liabilities)
            ->setBankruptcies($bankruptcies)
            ->setOtherIncomes($otherIncomes)
            ->setOtherProperties($otherProperties);
    }
    /**
     * Get ApplicantTypeId value
     * @return string
     */
    public function getApplicantTypeId()
    {
        return $this->ApplicantTypeId;
    }
    /**
     * Set ApplicantTypeId value
     * @uses \TurnedAwayBOSS\EnumType\ApplicantType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ApplicantType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicantTypeId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setApplicantTypeId($applicantTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ApplicantType::valueIsValid($applicantTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ApplicantType', is_array($applicantTypeId) ? implode(', ', $applicantTypeId) : var_export($applicantTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\ApplicantType::getValidValues())), __LINE__);
        }
        $this->ApplicantTypeId = $applicantTypeId;
        return $this;
    }
    /**
     * Get Authentication value
     * @return string
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @uses \TurnedAwayBOSS\EnumType\Authentication::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Authentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authentication
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setAuthentication($authentication = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Authentication::valueIsValid($authentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Authentication', is_array($authentication) ? implode(', ', $authentication) : var_export($authentication, true), implode(', ', \TurnedAwayBOSS\EnumType\Authentication::getValidValues())), __LINE__);
        }
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get LanguagePreferenceId value
     * @return string
     */
    public function getLanguagePreferenceId()
    {
        return $this->LanguagePreferenceId;
    }
    /**
     * Set LanguagePreferenceId value
     * @uses \TurnedAwayBOSS\EnumType\Language::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $languagePreferenceId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setLanguagePreferenceId($languagePreferenceId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Language::valueIsValid($languagePreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Language', is_array($languagePreferenceId) ? implode(', ', $languagePreferenceId) : var_export($languagePreferenceId, true), implode(', ', \TurnedAwayBOSS\EnumType\Language::getValidValues())), __LINE__);
        }
        $this->LanguagePreferenceId = $languagePreferenceId;
        return $this;
    }
    /**
     * Get MartialStatusId value
     * @return string
     */
    public function getMartialStatusId()
    {
        return $this->MartialStatusId;
    }
    /**
     * Set MartialStatusId value
     * @uses \TurnedAwayBOSS\EnumType\MaritalStatus::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\MaritalStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $martialStatusId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setMartialStatusId($martialStatusId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\MaritalStatus::valueIsValid($martialStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\MaritalStatus', is_array($martialStatusId) ? implode(', ', $martialStatusId) : var_export($martialStatusId, true), implode(', ', \TurnedAwayBOSS\EnumType\MaritalStatus::getValidValues())), __LINE__);
        }
        $this->MartialStatusId = $martialStatusId;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \TurnedAwayBOSS\EnumType\Gender::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Gender', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \TurnedAwayBOSS\EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get RelationshipToMainApplicant value
     * @return string
     */
    public function getRelationshipToMainApplicant()
    {
        return $this->RelationshipToMainApplicant;
    }
    /**
     * Set RelationshipToMainApplicant value
     * @uses \TurnedAwayBOSS\EnumType\Relation::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Relation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationshipToMainApplicant
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setRelationshipToMainApplicant($relationshipToMainApplicant = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Relation::valueIsValid($relationshipToMainApplicant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Relation', is_array($relationshipToMainApplicant) ? implode(', ', $relationshipToMainApplicant) : var_export($relationshipToMainApplicant, true), implode(', ', \TurnedAwayBOSS\EnumType\Relation::getValidValues())), __LINE__);
        }
        $this->RelationshipToMainApplicant = $relationshipToMainApplicant;
        return $this;
    }
    /**
     * Get IsResident value
     * @return bool
     */
    public function getIsResident()
    {
        return $this->IsResident;
    }
    /**
     * Set IsResident value
     * @param bool $isResident
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResident) && !is_bool($isResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->IsResident = $isResident;
        return $this;
    }
    /**
     * Get ResidentTypeId value
     * @return string
     */
    public function getResidentTypeId()
    {
        return $this->ResidentTypeId;
    }
    /**
     * Set ResidentTypeId value
     * @uses \TurnedAwayBOSS\EnumType\ResidentType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ResidentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $residentTypeId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setResidentTypeId($residentTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ResidentType::valueIsValid($residentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ResidentType', is_array($residentTypeId) ? implode(', ', $residentTypeId) : var_export($residentTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\ResidentType::getValidValues())), __LINE__);
        }
        $this->ResidentTypeId = $residentTypeId;
        return $this;
    }
    /**
     * Get Name value
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \TurnedAwayBOSS\StructType\Name $name
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setName(\TurnedAwayBOSS\StructType\Name $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NumberOfDependents value
     * @return int
     */
    public function getNumberOfDependents()
    {
        return $this->NumberOfDependents;
    }
    /**
     * Set NumberOfDependents value
     * @param int $numberOfDependents
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setNumberOfDependents($numberOfDependents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDependents) && !(is_int($numberOfDependents) || ctype_digit($numberOfDependents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDependents, true), gettype($numberOfDependents)), __LINE__);
        }
        $this->NumberOfDependents = $numberOfDependents;
        return $this;
    }
    /**
     * Get PrefferedContactMethodId value
     * @return string
     */
    public function getPrefferedContactMethodId()
    {
        return $this->PrefferedContactMethodId;
    }
    /**
     * Set PrefferedContactMethodId value
     * @uses \TurnedAwayBOSS\EnumType\ContactMethod::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ContactMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prefferedContactMethodId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setPrefferedContactMethodId($prefferedContactMethodId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ContactMethod::valueIsValid($prefferedContactMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ContactMethod', is_array($prefferedContactMethodId) ? implode(', ', $prefferedContactMethodId) : var_export($prefferedContactMethodId, true), implode(', ', \TurnedAwayBOSS\EnumType\ContactMethod::getValidValues())), __LINE__);
        }
        $this->PrefferedContactMethodId = $prefferedContactMethodId;
        return $this;
    }
    /**
     * Get SocialInsuranceNumber value
     * @return string
     */
    public function getSocialInsuranceNumber()
    {
        return $this->SocialInsuranceNumber;
    }
    /**
     * Set SocialInsuranceNumber value
     * @param string $socialInsuranceNumber
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setSocialInsuranceNumber($socialInsuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialInsuranceNumber) && !is_string($socialInsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialInsuranceNumber, true), gettype($socialInsuranceNumber)), __LINE__);
        }
        $this->SocialInsuranceNumber = $socialInsuranceNumber;
        return $this;
    }
    /**
     * Get BankruptcyStatusId value
     * @return string
     */
    public function getBankruptcyStatusId()
    {
        return $this->BankruptcyStatusId;
    }
    /**
     * Set BankruptcyStatusId value
     * @uses \TurnedAwayBOSS\EnumType\BankruptcyStatus::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\BankruptcyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankruptcyStatusId
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setBankruptcyStatusId($bankruptcyStatusId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\BankruptcyStatus::valueIsValid($bankruptcyStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\BankruptcyStatus', is_array($bankruptcyStatusId) ? implode(', ', $bankruptcyStatusId) : var_export($bankruptcyStatusId, true), implode(', ', \TurnedAwayBOSS\EnumType\BankruptcyStatus::getValidValues())), __LINE__);
        }
        $this->BankruptcyStatusId = $bankruptcyStatusId;
        return $this;
    }
    /**
     * Get ExistingClient value
     * @return bool
     */
    public function getExistingClient()
    {
        return $this->ExistingClient;
    }
    /**
     * Set ExistingClient value
     * @param bool $existingClient
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setExistingClient($existingClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($existingClient) && !is_bool($existingClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($existingClient, true), gettype($existingClient)), __LINE__);
        }
        $this->ExistingClient = $existingClient;
        return $this;
    }
    /**
     * Get IsFirstTimeBuyer value
     * @return bool
     */
    public function getIsFirstTimeBuyer()
    {
        return $this->IsFirstTimeBuyer;
    }
    /**
     * Set IsFirstTimeBuyer value
     * @param bool $isFirstTimeBuyer
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setIsFirstTimeBuyer($isFirstTimeBuyer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstTimeBuyer) && !is_bool($isFirstTimeBuyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstTimeBuyer, true), gettype($isFirstTimeBuyer)), __LINE__);
        }
        $this->IsFirstTimeBuyer = $isFirstTimeBuyer;
        return $this;
    }
    /**
     * Get ApplicantPhones value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfPhone|null
     */
    public function getApplicantPhones()
    {
        return $this->ApplicantPhones;
    }
    /**
     * Set ApplicantPhones value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfPhone $applicantPhones
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setApplicantPhones(\TurnedAwayBOSS\ArrayType\ArrayOfPhone $applicantPhones = null)
    {
        $this->ApplicantPhones = $applicantPhones;
        return $this;
    }
    /**
     * Get Identifications value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfIdentification|null
     */
    public function getIdentifications()
    {
        return $this->Identifications;
    }
    /**
     * Set Identifications value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfIdentification $identifications
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setIdentifications(\TurnedAwayBOSS\ArrayType\ArrayOfIdentification $identifications = null)
    {
        $this->Identifications = $identifications;
        return $this;
    }
    /**
     * Get ApplicantAddresses value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress|null
     */
    public function getApplicantAddresses()
    {
        return $this->ApplicantAddresses;
    }
    /**
     * Set ApplicantAddresses value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress $applicantAddresses
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setApplicantAddresses(\TurnedAwayBOSS\ArrayType\ArrayOfApplicantAddress $applicantAddresses = null)
    {
        $this->ApplicantAddresses = $applicantAddresses;
        return $this;
    }
    /**
     * Get Employments value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfEmployment|null
     */
    public function getEmployments()
    {
        return $this->Employments;
    }
    /**
     * Set Employments value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfEmployment $employments
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setEmployments(\TurnedAwayBOSS\ArrayType\ArrayOfEmployment $employments = null)
    {
        $this->Employments = $employments;
        return $this;
    }
    /**
     * Get Assets value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfAsset|null
     */
    public function getAssets()
    {
        return $this->Assets;
    }
    /**
     * Set Assets value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfAsset $assets
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setAssets(\TurnedAwayBOSS\ArrayType\ArrayOfAsset $assets = null)
    {
        $this->Assets = $assets;
        return $this;
    }
    /**
     * Get Liabilities value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfLiability|null
     */
    public function getLiabilities()
    {
        return $this->Liabilities;
    }
    /**
     * Set Liabilities value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfLiability $liabilities
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setLiabilities(\TurnedAwayBOSS\ArrayType\ArrayOfLiability $liabilities = null)
    {
        $this->Liabilities = $liabilities;
        return $this;
    }
    /**
     * Get Bankruptcies value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy|null
     */
    public function getBankruptcies()
    {
        return $this->Bankruptcies;
    }
    /**
     * Set Bankruptcies value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy $bankruptcies
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setBankruptcies(\TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy $bankruptcies = null)
    {
        $this->Bankruptcies = $bankruptcies;
        return $this;
    }
    /**
     * Get OtherIncomes value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome|null
     */
    public function getOtherIncomes()
    {
        return $this->OtherIncomes;
    }
    /**
     * Set OtherIncomes value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome $otherIncomes
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setOtherIncomes(\TurnedAwayBOSS\ArrayType\ArrayOfOtherIncome $otherIncomes = null)
    {
        $this->OtherIncomes = $otherIncomes;
        return $this;
    }
    /**
     * Get OtherProperties value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty|null
     */
    public function getOtherProperties()
    {
        return $this->OtherProperties;
    }
    /**
     * Set OtherProperties value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty $otherProperties
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public function setOtherProperties(\TurnedAwayBOSS\ArrayType\ArrayOfApplicantProperty $otherProperties = null)
    {
        $this->OtherProperties = $otherProperties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Applicant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
