<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pull ServiceType
 * @subpackage Services
 */
class Pull extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PullNextDeal
     * Meta information extracted from the WSDL
     * - documentation: Get the next available deal being submitted. / Récupérer le prochain dossier soumis disponible.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullNextDeal $parameters
     * @return \TurnedAwayBOSS\StructType\PullNextDealResponse|bool
     */
    public function PullNextDeal(\TurnedAwayBOSS\StructType\PullNextDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullNextDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PullNextUpdatedDeal
     * Meta information extracted from the WSDL
     * - documentation: Get the next updated deal previously submitted. / Récupérer le prochain dossier modifié après avoir été soumis.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullNextUpdatedDeal $parameters
     * @return \TurnedAwayBOSS\StructType\PullNextUpdatedDealResponse|bool
     */
    public function PullNextUpdatedDeal(\TurnedAwayBOSS\StructType\PullNextUpdatedDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullNextUpdatedDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PullSpecificDeal
     * Meta information extracted from the WSDL
     * - documentation: Get a specific deal being submitted. / Récupérer un dossier spécifique et déjà soumis.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullSpecificDeal $parameters
     * @return \TurnedAwayBOSS\StructType\PullSpecificDealResponse|bool
     */
    public function PullSpecificDeal(\TurnedAwayBOSS\StructType\PullSpecificDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullSpecificDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PullDocumentList
     * Meta information extracted from the WSDL
     * - documentation: Get a list of documents associated to a specific deal. / Obtenir la liste de documents liés à un dossier spécifique.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullDocumentList $parameters
     * @return \TurnedAwayBOSS\StructType\PullDocumentListResponse|bool
     */
    public function PullDocumentList(\TurnedAwayBOSS\StructType\PullDocumentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullDocumentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PullDocument
     * Meta information extracted from the WSDL
     * - documentation: Get a specific document of a deal. / Obtenir un document spécifique d'un dossier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullDocument $parameters
     * @return \TurnedAwayBOSS\StructType\PullDocumentResponse|bool
     */
    public function PullDocument(\TurnedAwayBOSS\StructType\PullDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PullDocuments
     * Meta information extracted from the WSDL
     * - documentation: Get all documents of a deal. / Obtenir tous les documents d'un dossier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PullDocuments $parameters
     * @return \TurnedAwayBOSS\StructType\PullDocumentsResponse|bool
     */
    public function PullDocuments(\TurnedAwayBOSS\StructType\PullDocuments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PullDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\PullDocumentListResponse|\TurnedAwayBOSS\StructType\PullDocumentResponse|\TurnedAwayBOSS\StructType\PullDocumentsResponse|\TurnedAwayBOSS\StructType\PullNextDealResponse|\TurnedAwayBOSS\StructType\PullNextUpdatedDealResponse|\TurnedAwayBOSS\StructType\PullSpecificDealResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
