<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Logout ServiceType
 * @subpackage Services
 */
class Logout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Logout
     * Meta information extracted from the WSDL
     * - documentation: Close the session associated to the token. / Fermer la session associée à la clef.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\Logout $parameters
     * @return \TurnedAwayBOSS\StructType\LogoutResponse|bool
     */
    public function Logout(\TurnedAwayBOSS\StructType\Logout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Logout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\LogoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
