<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ack ServiceType
 * @subpackage Services
 */
class Ack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AckPullDeal
     * Meta information extracted from the WSDL
     * - documentation: Acknowledge that the deal was successfully received. / Approuver la réception du dossier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\AckPullDeal $parameters
     * @return \TurnedAwayBOSS\StructType\AckPullDealResponse|bool
     */
    public function AckPullDeal(\TurnedAwayBOSS\StructType\AckPullDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AckPullDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AckSpecificSubmission
     * Meta information extracted from the WSDL
     * - documentation: Acknowledge that the deal was successfully received by using BOSS Deal ID and Submission ID. / Approuver la réception du dossier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\AckSpecificSubmission $parameters
     * @return \TurnedAwayBOSS\StructType\AckSpecificSubmissionResponse|bool
     */
    public function AckSpecificSubmission(\TurnedAwayBOSS\StructType\AckSpecificSubmission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AckSpecificSubmission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\AckPullDealResponse|\TurnedAwayBOSS\StructType\AckSpecificSubmissionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
