<?php

namespace TurnedAwayBOSS\EnumType;

/**
 * This class stands for ApplicantGroupType EnumType
 * @subpackage Enumerations
 */
class ApplicantGroupType
{
    /**
     * Constant for value '0'
     * @return string '0'
     */
    const VALUE_0 = '0';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_0
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_0,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
