<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentification ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentification extends AbstractStructArrayBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Identification[]
     */
    public $Identification;
    /**
     * Constructor method for ArrayOfIdentification
     * @uses ArrayOfIdentification::setIdentification()
     * @param \TurnedAwayBOSS\StructType\Identification[] $identification
     */
    public function __construct(array $identification = array())
    {
        $this
            ->setIdentification($identification);
    }
    /**
     * Get Identification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Identification[]|null
     */
    public function getIdentification()
    {
        return isset($this->Identification) ? $this->Identification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentificationForArrayConstraintsFromSetIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdentificationIdentificationItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentificationIdentificationItem instanceof \TurnedAwayBOSS\StructType\Identification) {
                $invalidValues[] = is_object($arrayOfIdentificationIdentificationItem) ? get_class($arrayOfIdentificationIdentificationItem) : sprintf('%s(%s)', gettype($arrayOfIdentificationIdentificationItem), var_export($arrayOfIdentificationIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Identification property can only contain items of type \TurnedAwayBOSS\StructType\Identification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Identification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Identification[] $identification
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfIdentification
     */
    public function setIdentification(array $identification = array())
    {
        // validation for constraint: array
        if ('' !== ($identificationArrayErrorMessage = self::validateIdentificationForArrayConstraintsFromSetIdentification($identification))) {
            throw new \InvalidArgumentException($identificationArrayErrorMessage, __LINE__);
        }
        if (is_null($identification) || (is_array($identification) && empty($identification))) {
            unset($this->Identification);
        } else {
            $this->Identification = $identification;
        }
        return $this;
    }
    /**
     * Add item to Identification value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Identification $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfIdentification
     */
    public function addToIdentification(\TurnedAwayBOSS\StructType\Identification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Identification) {
            throw new \InvalidArgumentException(sprintf('The Identification property can only contain items of type \TurnedAwayBOSS\StructType\Identification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Identification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Identification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Identification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Identification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Identification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Identification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Identification
     */
    public function getAttributeName()
    {
        return 'Identification';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfIdentification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
