<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmployment ArrayType
 * @subpackage Arrays
 */
class ArrayOfEmployment extends AbstractStructArrayBase
{
    /**
     * The Employment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Employment[]
     */
    public $Employment;
    /**
     * Constructor method for ArrayOfEmployment
     * @uses ArrayOfEmployment::setEmployment()
     * @param \TurnedAwayBOSS\StructType\Employment[] $employment
     */
    public function __construct(array $employment = array())
    {
        $this
            ->setEmployment($employment);
    }
    /**
     * Get Employment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Employment[]|null
     */
    public function getEmployment()
    {
        return isset($this->Employment) ? $this->Employment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmploymentForArrayConstraintsFromSetEmployment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEmploymentEmploymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmploymentEmploymentItem instanceof \TurnedAwayBOSS\StructType\Employment) {
                $invalidValues[] = is_object($arrayOfEmploymentEmploymentItem) ? get_class($arrayOfEmploymentEmploymentItem) : sprintf('%s(%s)', gettype($arrayOfEmploymentEmploymentItem), var_export($arrayOfEmploymentEmploymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employment property can only contain items of type \TurnedAwayBOSS\StructType\Employment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Employment[] $employment
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfEmployment
     */
    public function setEmployment(array $employment = array())
    {
        // validation for constraint: array
        if ('' !== ($employmentArrayErrorMessage = self::validateEmploymentForArrayConstraintsFromSetEmployment($employment))) {
            throw new \InvalidArgumentException($employmentArrayErrorMessage, __LINE__);
        }
        if (is_null($employment) || (is_array($employment) && empty($employment))) {
            unset($this->Employment);
        } else {
            $this->Employment = $employment;
        }
        return $this;
    }
    /**
     * Add item to Employment value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Employment $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfEmployment
     */
    public function addToEmployment(\TurnedAwayBOSS\StructType\Employment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Employment) {
            throw new \InvalidArgumentException(sprintf('The Employment property can only contain items of type \TurnedAwayBOSS\StructType\Employment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Employment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Employment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Employment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Employment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Employment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Employment
     */
    public function getAttributeName()
    {
        return 'Employment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfEmployment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
