<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankruptcy ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankruptcy extends AbstractStructArrayBase
{
    /**
     * The Bankruptcy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Bankruptcy[]
     */
    public $Bankruptcy;
    /**
     * Constructor method for ArrayOfBankruptcy
     * @uses ArrayOfBankruptcy::setBankruptcy()
     * @param \TurnedAwayBOSS\StructType\Bankruptcy[] $bankruptcy
     */
    public function __construct(array $bankruptcy = array())
    {
        $this
            ->setBankruptcy($bankruptcy);
    }
    /**
     * Get Bankruptcy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Bankruptcy[]|null
     */
    public function getBankruptcy()
    {
        return isset($this->Bankruptcy) ? $this->Bankruptcy : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBankruptcy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankruptcy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankruptcyForArrayConstraintsFromSetBankruptcy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBankruptcyBankruptcyItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankruptcyBankruptcyItem instanceof \TurnedAwayBOSS\StructType\Bankruptcy) {
                $invalidValues[] = is_object($arrayOfBankruptcyBankruptcyItem) ? get_class($arrayOfBankruptcyBankruptcyItem) : sprintf('%s(%s)', gettype($arrayOfBankruptcyBankruptcyItem), var_export($arrayOfBankruptcyBankruptcyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bankruptcy property can only contain items of type \TurnedAwayBOSS\StructType\Bankruptcy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bankruptcy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Bankruptcy[] $bankruptcy
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy
     */
    public function setBankruptcy(array $bankruptcy = array())
    {
        // validation for constraint: array
        if ('' !== ($bankruptcyArrayErrorMessage = self::validateBankruptcyForArrayConstraintsFromSetBankruptcy($bankruptcy))) {
            throw new \InvalidArgumentException($bankruptcyArrayErrorMessage, __LINE__);
        }
        if (is_null($bankruptcy) || (is_array($bankruptcy) && empty($bankruptcy))) {
            unset($this->Bankruptcy);
        } else {
            $this->Bankruptcy = $bankruptcy;
        }
        return $this;
    }
    /**
     * Add item to Bankruptcy value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Bankruptcy $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy
     */
    public function addToBankruptcy(\TurnedAwayBOSS\StructType\Bankruptcy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Bankruptcy) {
            throw new \InvalidArgumentException(sprintf('The Bankruptcy property can only contain items of type \TurnedAwayBOSS\StructType\Bankruptcy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bankruptcy[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Bankruptcy|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Bankruptcy|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Bankruptcy|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Bankruptcy|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Bankruptcy|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Bankruptcy
     */
    public function getAttributeName()
    {
        return 'Bankruptcy';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfBankruptcy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
