<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAsset ArrayType
 * @subpackage Arrays
 */
class ArrayOfAsset extends AbstractStructArrayBase
{
    /**
     * The Asset
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Asset[]
     */
    public $Asset;
    /**
     * Constructor method for ArrayOfAsset
     * @uses ArrayOfAsset::setAsset()
     * @param \TurnedAwayBOSS\StructType\Asset[] $asset
     */
    public function __construct(array $asset = array())
    {
        $this
            ->setAsset($asset);
    }
    /**
     * Get Asset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Asset[]|null
     */
    public function getAsset()
    {
        return isset($this->Asset) ? $this->Asset : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssetForArrayConstraintsFromSetAsset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAssetAssetItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssetAssetItem instanceof \TurnedAwayBOSS\StructType\Asset) {
                $invalidValues[] = is_object($arrayOfAssetAssetItem) ? get_class($arrayOfAssetAssetItem) : sprintf('%s(%s)', gettype($arrayOfAssetAssetItem), var_export($arrayOfAssetAssetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset property can only contain items of type \TurnedAwayBOSS\StructType\Asset, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Asset[] $asset
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfAsset
     */
    public function setAsset(array $asset = array())
    {
        // validation for constraint: array
        if ('' !== ($assetArrayErrorMessage = self::validateAssetForArrayConstraintsFromSetAsset($asset))) {
            throw new \InvalidArgumentException($assetArrayErrorMessage, __LINE__);
        }
        if (is_null($asset) || (is_array($asset) && empty($asset))) {
            unset($this->Asset);
        } else {
            $this->Asset = $asset;
        }
        return $this;
    }
    /**
     * Add item to Asset value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Asset $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfAsset
     */
    public function addToAsset(\TurnedAwayBOSS\StructType\Asset $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Asset) {
            throw new \InvalidArgumentException(sprintf('The Asset property can only contain items of type \TurnedAwayBOSS\StructType\Asset, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Asset|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Asset|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Asset|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Asset|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Asset|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Asset
     */
    public function getAttributeName()
    {
        return 'Asset';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfAsset
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
