<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfApplicant ArrayType
 * @subpackage Arrays
 */
class ArrayOfApplicant extends AbstractStructArrayBase
{
    /**
     * The Applicant
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Applicant[]
     */
    public $Applicant;
    /**
     * Constructor method for ArrayOfApplicant
     * @uses ArrayOfApplicant::setApplicant()
     * @param \TurnedAwayBOSS\StructType\Applicant[] $applicant
     */
    public function __construct(array $applicant = array())
    {
        $this
            ->setApplicant($applicant);
    }
    /**
     * Get Applicant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Applicant[]|null
     */
    public function getApplicant()
    {
        return isset($this->Applicant) ? $this->Applicant : null;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicantForArrayConstraintsFromSetApplicant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfApplicantApplicantItem) {
            // validation for constraint: itemType
            if (!$arrayOfApplicantApplicantItem instanceof \TurnedAwayBOSS\StructType\Applicant) {
                $invalidValues[] = is_object($arrayOfApplicantApplicantItem) ? get_class($arrayOfApplicantApplicantItem) : sprintf('%s(%s)', gettype($arrayOfApplicantApplicantItem), var_export($arrayOfApplicantApplicantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant property can only contain items of type \TurnedAwayBOSS\StructType\Applicant, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Applicant[] $applicant
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicant
     */
    public function setApplicant(array $applicant = array())
    {
        // validation for constraint: array
        if ('' !== ($applicantArrayErrorMessage = self::validateApplicantForArrayConstraintsFromSetApplicant($applicant))) {
            throw new \InvalidArgumentException($applicantArrayErrorMessage, __LINE__);
        }
        if (is_null($applicant) || (is_array($applicant) && empty($applicant))) {
            unset($this->Applicant);
        } else {
            $this->Applicant = $applicant;
        }
        return $this;
    }
    /**
     * Add item to Applicant value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Applicant $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicant
     */
    public function addToApplicant(\TurnedAwayBOSS\StructType\Applicant $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Applicant) {
            throw new \InvalidArgumentException(sprintf('The Applicant property can only contain items of type \TurnedAwayBOSS\StructType\Applicant, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Applicant|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Applicant|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Applicant|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Applicant|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Applicant|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Applicant
     */
    public function getAttributeName()
    {
        return 'Applicant';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
