<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://partnersuatapi.mortgageboss.ca/boss_api.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://partnersuatapi.mortgageboss.ca/boss_api.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \TurnedAwayBOSS\ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \TurnedAwayBOSS\ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \TurnedAwayBOSS\StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \TurnedAwayBOSS\ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \TurnedAwayBOSS\StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Pull ServiceType
 */
$pull = new \TurnedAwayBOSS\ServiceType\Pull($options);
/**
 * Sample call for PullNextDeal operation/method
 */
if ($pull->PullNextDeal(new \TurnedAwayBOSS\StructType\PullNextDeal()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Sample call for PullNextUpdatedDeal operation/method
 */
if ($pull->PullNextUpdatedDeal(new \TurnedAwayBOSS\StructType\PullNextUpdatedDeal()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Sample call for PullSpecificDeal operation/method
 */
if ($pull->PullSpecificDeal(new \TurnedAwayBOSS\StructType\PullSpecificDeal()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Sample call for PullDocumentList operation/method
 */
if ($pull->PullDocumentList(new \TurnedAwayBOSS\StructType\PullDocumentList()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Sample call for PullDocument operation/method
 */
if ($pull->PullDocument(new \TurnedAwayBOSS\StructType\PullDocument()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Sample call for PullDocuments operation/method
 */
if ($pull->PullDocuments(new \TurnedAwayBOSS\StructType\PullDocuments()) !== false) {
    print_r($pull->getResult());
} else {
    print_r($pull->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \TurnedAwayBOSS\ServiceType\_List($options);
/**
 * Sample call for ListAvailableDeals operation/method
 */
if ($list->ListAvailableDeals(new \TurnedAwayBOSS\StructType\ListAvailableDeals()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListUpdatedDeals operation/method
 */
if ($list->ListUpdatedDeals(new \TurnedAwayBOSS\StructType\ListUpdatedDeals()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Ack ServiceType
 */
$ack = new \TurnedAwayBOSS\ServiceType\Ack($options);
/**
 * Sample call for AckPullDeal operation/method
 */
if ($ack->AckPullDeal(new \TurnedAwayBOSS\StructType\AckPullDeal()) !== false) {
    print_r($ack->getResult());
} else {
    print_r($ack->getLastError());
}
/**
 * Sample call for AckSpecificSubmission operation/method
 */
if ($ack->AckSpecificSubmission(new \TurnedAwayBOSS\StructType\AckSpecificSubmission()) !== false) {
    print_r($ack->getResult());
} else {
    print_r($ack->getLastError());
}
/**
 * Samples for Count ServiceType
 */
$count = new \TurnedAwayBOSS\ServiceType\Count($options);
/**
 * Sample call for CountAvailableDeals operation/method
 */
if ($count->CountAvailableDeals(new \TurnedAwayBOSS\StructType\CountAvailableDeals()) !== false) {
    print_r($count->getResult());
} else {
    print_r($count->getLastError());
}
/**
 * Sample call for CountUpdatedDeals operation/method
 */
if ($count->CountUpdatedDeals(new \TurnedAwayBOSS\StructType\CountUpdatedDeals()) !== false) {
    print_r($count->getResult());
} else {
    print_r($count->getLastError());
}
/**
 * Samples for Push ServiceType
 */
$push = new \TurnedAwayBOSS\ServiceType\Push($options);
/**
 * Sample call for PushResponse operation/method
 */
if ($push->PushResponse(new \TurnedAwayBOSS\StructType\PushResponse()) !== false) {
    print_r($push->getResult());
} else {
    print_r($push->getLastError());
}
/**
 * Sample call for PushDeal operation/method
 */
if ($push->PushDeal(new \TurnedAwayBOSS\StructType\PushDeal()) !== false) {
    print_r($push->getResult());
} else {
    print_r($push->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \TurnedAwayBOSS\ServiceType\Get($options);
/**
 * Sample call for GetNetworkAndBrand operation/method
 */
if ($get->GetNetworkAndBrand(new \TurnedAwayBOSS\StructType\GetNetworkAndBrand()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Recalc ServiceType
 */
$recalc = new \TurnedAwayBOSS\ServiceType\Recalc($options);
/**
 * Sample call for RecalcBRE operation/method
 */
if ($recalc->RecalcBRE(new \TurnedAwayBOSS\StructType\RecalcBRE()) !== false) {
    print_r($recalc->getResult());
} else {
    print_r($recalc->getLastError());
}
