<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelfEmploymentDetail StructType
 * @subpackage Structs
 */
class SelfEmploymentDetail extends AbstractStructBase
{
    /**
     * The CompanyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CompanyType;
    /**
     * The GrossRevenue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $GrossRevenue;
    /**
     * The OperatingAs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OperatingAs;
    /**
     * Constructor method for SelfEmploymentDetail
     * @uses SelfEmploymentDetail::setCompanyType()
     * @uses SelfEmploymentDetail::setGrossRevenue()
     * @uses SelfEmploymentDetail::setOperatingAs()
     * @param string $companyType
     * @param float $grossRevenue
     * @param string $operatingAs
     */
    public function __construct($companyType = null, $grossRevenue = null, $operatingAs = null)
    {
        $this
            ->setCompanyType($companyType)
            ->setGrossRevenue($grossRevenue)
            ->setOperatingAs($operatingAs);
    }
    /**
     * Get CompanyType value
     * @return string
     */
    public function getCompanyType()
    {
        return $this->CompanyType;
    }
    /**
     * Set CompanyType value
     * @param string $companyType
     * @return \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public function setCompanyType($companyType = null)
    {
        // validation for constraint: string
        if (!is_null($companyType) && !is_string($companyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyType, true), gettype($companyType)), __LINE__);
        }
        $this->CompanyType = $companyType;
        return $this;
    }
    /**
     * Get GrossRevenue value
     * @return float
     */
    public function getGrossRevenue()
    {
        return $this->GrossRevenue;
    }
    /**
     * Set GrossRevenue value
     * @param float $grossRevenue
     * @return \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public function setGrossRevenue($grossRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($grossRevenue) && !(is_float($grossRevenue) || is_numeric($grossRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossRevenue, true), gettype($grossRevenue)), __LINE__);
        }
        $this->GrossRevenue = $grossRevenue;
        return $this;
    }
    /**
     * Get OperatingAs value
     * @return string
     */
    public function getOperatingAs()
    {
        return $this->OperatingAs;
    }
    /**
     * Set OperatingAs value
     * @param string $operatingAs
     * @return \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public function setOperatingAs($operatingAs = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAs) && !is_string($operatingAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingAs, true), gettype($operatingAs)), __LINE__);
        }
        $this->OperatingAs = $operatingAs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
