<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PullDocument StructType
 * @subpackage Structs
 */
class PullDocument extends AbstractStructBase
{
    /**
     * The DocID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocID;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * Constructor method for PullDocument
     * @uses PullDocument::setDocID()
     * @uses PullDocument::setToken()
     * @param int $docID
     * @param string $token
     */
    public function __construct($docID = null, $token = null)
    {
        $this
            ->setDocID($docID)
            ->setToken($token);
    }
    /**
     * Get DocID value
     * @return int
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param int $docID
     * @return \TurnedAwayBOSS\StructType\PullDocument
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: int
        if (!is_null($docID) && !(is_int($docID) || ctype_digit($docID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \TurnedAwayBOSS\StructType\PullDocument
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\PullDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
