<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyRentalIncome StructType
 * @subpackage Structs
 */
class PropertyRentalIncome extends AbstractStructBase
{
    /**
     * The IncomeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $IncomeAmount;
    /**
     * The IncomePeriodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IncomePeriodId;
    /**
     * The RentalIncomeOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RentalIncomeOption;
    /**
     * The IncludeOffset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $IncludeOffset;
    /**
     * Constructor method for PropertyRentalIncome
     * @uses PropertyRentalIncome::setIncomeAmount()
     * @uses PropertyRentalIncome::setIncomePeriodId()
     * @uses PropertyRentalIncome::setRentalIncomeOption()
     * @uses PropertyRentalIncome::setIncludeOffset()
     * @param float $incomeAmount
     * @param string $incomePeriodId
     * @param string $rentalIncomeOption
     * @param float $includeOffset
     */
    public function __construct($incomeAmount = null, $incomePeriodId = null, $rentalIncomeOption = null, $includeOffset = null)
    {
        $this
            ->setIncomeAmount($incomeAmount)
            ->setIncomePeriodId($incomePeriodId)
            ->setRentalIncomeOption($rentalIncomeOption)
            ->setIncludeOffset($includeOffset);
    }
    /**
     * Get IncomeAmount value
     * @return float
     */
    public function getIncomeAmount()
    {
        return $this->IncomeAmount;
    }
    /**
     * Set IncomeAmount value
     * @param float $incomeAmount
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public function setIncomeAmount($incomeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($incomeAmount) && !(is_float($incomeAmount) || is_numeric($incomeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incomeAmount, true), gettype($incomeAmount)), __LINE__);
        }
        $this->IncomeAmount = $incomeAmount;
        return $this;
    }
    /**
     * Get IncomePeriodId value
     * @return string
     */
    public function getIncomePeriodId()
    {
        return $this->IncomePeriodId;
    }
    /**
     * Set IncomePeriodId value
     * @uses \TurnedAwayBOSS\EnumType\Period::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Period::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomePeriodId
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public function setIncomePeriodId($incomePeriodId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Period::valueIsValid($incomePeriodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Period', is_array($incomePeriodId) ? implode(', ', $incomePeriodId) : var_export($incomePeriodId, true), implode(', ', \TurnedAwayBOSS\EnumType\Period::getValidValues())), __LINE__);
        }
        $this->IncomePeriodId = $incomePeriodId;
        return $this;
    }
    /**
     * Get RentalIncomeOption value
     * @return string
     */
    public function getRentalIncomeOption()
    {
        return $this->RentalIncomeOption;
    }
    /**
     * Set RentalIncomeOption value
     * @uses \TurnedAwayBOSS\EnumType\RentalIncomeOption::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\RentalIncomeOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rentalIncomeOption
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public function setRentalIncomeOption($rentalIncomeOption = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\RentalIncomeOption::valueIsValid($rentalIncomeOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\RentalIncomeOption', is_array($rentalIncomeOption) ? implode(', ', $rentalIncomeOption) : var_export($rentalIncomeOption, true), implode(', ', \TurnedAwayBOSS\EnumType\RentalIncomeOption::getValidValues())), __LINE__);
        }
        $this->RentalIncomeOption = $rentalIncomeOption;
        return $this;
    }
    /**
     * Get IncludeOffset value
     * @return float
     */
    public function getIncludeOffset()
    {
        return $this->IncludeOffset;
    }
    /**
     * Set IncludeOffset value
     * @param float $includeOffset
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public function setIncludeOffset($includeOffset = null)
    {
        // validation for constraint: float
        if (!is_null($includeOffset) && !(is_float($includeOffset) || is_numeric($includeOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($includeOffset, true), gettype($includeOffset)), __LINE__);
        }
        $this->IncludeOffset = $includeOffset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
