<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkBrand StructType
 * @subpackage Structs
 */
class NetworkBrand extends AbstractStructBase
{
    /**
     * The NetworkId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NetworkId;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * Constructor method for NetworkBrand
     * @uses NetworkBrand::setNetworkId()
     * @uses NetworkBrand::setBrand()
     * @param int $networkId
     * @param string $brand
     */
    public function __construct($networkId = null, $brand = null)
    {
        $this
            ->setNetworkId($networkId)
            ->setBrand($brand);
    }
    /**
     * Get NetworkId value
     * @return int
     */
    public function getNetworkId()
    {
        return $this->NetworkId;
    }
    /**
     * Set NetworkId value
     * @param int $networkId
     * @return \TurnedAwayBOSS\StructType\NetworkBrand
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: int
        if (!is_null($networkId) && !(is_int($networkId) || ctype_digit($networkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        $this->NetworkId = $networkId;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \TurnedAwayBOSS\StructType\NetworkBrand
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\NetworkBrand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
