<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MortgageRequest StructType
 * @subpackage Structs
 */
class MortgageRequest extends AbstractStructBase
{
    /**
     * The MortgageTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MortgageTypeId;
    /**
     * The NetLoanAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $NetLoanAmount;
    /**
     * The TotalLoanAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalLoanAmount;
    /**
     * The LoanTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LoanTypeId;
    /**
     * The MaturityDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaturityDate;
    /**
     * The SingleProgressiveTypeFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SingleProgressiveTypeFlag;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Rate
     */
    public $Rate;
    /**
     * The InterestTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InterestTypeId;
    /**
     * The PaymentTermId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentTermId;
    /**
     * The PaymentFrequencyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentFrequencyId;
    /**
     * The InterestCompoundId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InterestCompoundId;
    /**
     * The ActualPaymentTerm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ActualPaymentTerm;
    /**
     * The AmortizationTerm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AmortizationTerm;
    /**
     * The InterestOnlyFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InterestOnlyFlag;
    /**
     * The RefiBlendedAmortization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RefiBlendedAmortization;
    /**
     * The Insurer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Insurer;
    /**
     * The MtgInsIncludeFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MtgInsIncludeFlag;
    /**
     * The InsPrimeRateOverrideFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InsPrimeRateOverrideFlag;
    /**
     * The InsPrimeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InsPrimeRate;
    /**
     * The InsMortgagePremium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InsMortgagePremium;
    /**
     * The LocRepaymentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LocRepaymentTypeId;
    /**
     * The CashBackOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CashBackOverride;
    /**
     * The CashBackPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CashBackPercentage;
    /**
     * The CashBackAmt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CashBackAmt;
    /**
     * The FirstPaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FirstPaymentDate;
    /**
     * Constructor method for MortgageRequest
     * @uses MortgageRequest::setMortgageTypeId()
     * @uses MortgageRequest::setNetLoanAmount()
     * @uses MortgageRequest::setTotalLoanAmount()
     * @uses MortgageRequest::setLoanTypeId()
     * @uses MortgageRequest::setMaturityDate()
     * @uses MortgageRequest::setSingleProgressiveTypeFlag()
     * @uses MortgageRequest::setRate()
     * @uses MortgageRequest::setInterestTypeId()
     * @uses MortgageRequest::setPaymentTermId()
     * @uses MortgageRequest::setPaymentFrequencyId()
     * @uses MortgageRequest::setInterestCompoundId()
     * @uses MortgageRequest::setActualPaymentTerm()
     * @uses MortgageRequest::setAmortizationTerm()
     * @uses MortgageRequest::setInterestOnlyFlag()
     * @uses MortgageRequest::setRefiBlendedAmortization()
     * @uses MortgageRequest::setInsurer()
     * @uses MortgageRequest::setMtgInsIncludeFlag()
     * @uses MortgageRequest::setInsPrimeRateOverrideFlag()
     * @uses MortgageRequest::setInsPrimeRate()
     * @uses MortgageRequest::setInsMortgagePremium()
     * @uses MortgageRequest::setLocRepaymentTypeId()
     * @uses MortgageRequest::setCashBackOverride()
     * @uses MortgageRequest::setCashBackPercentage()
     * @uses MortgageRequest::setCashBackAmt()
     * @uses MortgageRequest::setFirstPaymentDate()
     * @param string $mortgageTypeId
     * @param float $netLoanAmount
     * @param float $totalLoanAmount
     * @param string $loanTypeId
     * @param string $maturityDate
     * @param bool $singleProgressiveTypeFlag
     * @param \TurnedAwayBOSS\StructType\Rate $rate
     * @param string $interestTypeId
     * @param string $paymentTermId
     * @param string $paymentFrequencyId
     * @param string $interestCompoundId
     * @param int $actualPaymentTerm
     * @param int $amortizationTerm
     * @param bool $interestOnlyFlag
     * @param bool $refiBlendedAmortization
     * @param string $insurer
     * @param bool $mtgInsIncludeFlag
     * @param bool $insPrimeRateOverrideFlag
     * @param float $insPrimeRate
     * @param float $insMortgagePremium
     * @param string $locRepaymentTypeId
     * @param bool $cashBackOverride
     * @param float $cashBackPercentage
     * @param float $cashBackAmt
     * @param string $firstPaymentDate
     */
    public function __construct($mortgageTypeId = null, $netLoanAmount = null, $totalLoanAmount = null, $loanTypeId = null, $maturityDate = null, $singleProgressiveTypeFlag = null, \TurnedAwayBOSS\StructType\Rate $rate = null, $interestTypeId = null, $paymentTermId = null, $paymentFrequencyId = null, $interestCompoundId = null, $actualPaymentTerm = null, $amortizationTerm = null, $interestOnlyFlag = null, $refiBlendedAmortization = null, $insurer = null, $mtgInsIncludeFlag = null, $insPrimeRateOverrideFlag = null, $insPrimeRate = null, $insMortgagePremium = null, $locRepaymentTypeId = null, $cashBackOverride = null, $cashBackPercentage = null, $cashBackAmt = null, $firstPaymentDate = null)
    {
        $this
            ->setMortgageTypeId($mortgageTypeId)
            ->setNetLoanAmount($netLoanAmount)
            ->setTotalLoanAmount($totalLoanAmount)
            ->setLoanTypeId($loanTypeId)
            ->setMaturityDate($maturityDate)
            ->setSingleProgressiveTypeFlag($singleProgressiveTypeFlag)
            ->setRate($rate)
            ->setInterestTypeId($interestTypeId)
            ->setPaymentTermId($paymentTermId)
            ->setPaymentFrequencyId($paymentFrequencyId)
            ->setInterestCompoundId($interestCompoundId)
            ->setActualPaymentTerm($actualPaymentTerm)
            ->setAmortizationTerm($amortizationTerm)
            ->setInterestOnlyFlag($interestOnlyFlag)
            ->setRefiBlendedAmortization($refiBlendedAmortization)
            ->setInsurer($insurer)
            ->setMtgInsIncludeFlag($mtgInsIncludeFlag)
            ->setInsPrimeRateOverrideFlag($insPrimeRateOverrideFlag)
            ->setInsPrimeRate($insPrimeRate)
            ->setInsMortgagePremium($insMortgagePremium)
            ->setLocRepaymentTypeId($locRepaymentTypeId)
            ->setCashBackOverride($cashBackOverride)
            ->setCashBackPercentage($cashBackPercentage)
            ->setCashBackAmt($cashBackAmt)
            ->setFirstPaymentDate($firstPaymentDate);
    }
    /**
     * Get MortgageTypeId value
     * @return string
     */
    public function getMortgageTypeId()
    {
        return $this->MortgageTypeId;
    }
    /**
     * Set MortgageTypeId value
     * @uses \TurnedAwayBOSS\EnumType\MortgageType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\MortgageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mortgageTypeId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setMortgageTypeId($mortgageTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\MortgageType::valueIsValid($mortgageTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\MortgageType', is_array($mortgageTypeId) ? implode(', ', $mortgageTypeId) : var_export($mortgageTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\MortgageType::getValidValues())), __LINE__);
        }
        $this->MortgageTypeId = $mortgageTypeId;
        return $this;
    }
    /**
     * Get NetLoanAmount value
     * @return float
     */
    public function getNetLoanAmount()
    {
        return $this->NetLoanAmount;
    }
    /**
     * Set NetLoanAmount value
     * @param float $netLoanAmount
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setNetLoanAmount($netLoanAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netLoanAmount) && !(is_float($netLoanAmount) || is_numeric($netLoanAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netLoanAmount, true), gettype($netLoanAmount)), __LINE__);
        }
        $this->NetLoanAmount = $netLoanAmount;
        return $this;
    }
    /**
     * Get TotalLoanAmount value
     * @return float
     */
    public function getTotalLoanAmount()
    {
        return $this->TotalLoanAmount;
    }
    /**
     * Set TotalLoanAmount value
     * @param float $totalLoanAmount
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setTotalLoanAmount($totalLoanAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalLoanAmount) && !(is_float($totalLoanAmount) || is_numeric($totalLoanAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalLoanAmount, true), gettype($totalLoanAmount)), __LINE__);
        }
        $this->TotalLoanAmount = $totalLoanAmount;
        return $this;
    }
    /**
     * Get LoanTypeId value
     * @return string
     */
    public function getLoanTypeId()
    {
        return $this->LoanTypeId;
    }
    /**
     * Set LoanTypeId value
     * @uses \TurnedAwayBOSS\EnumType\LoanType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\LoanType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loanTypeId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setLoanTypeId($loanTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\LoanType::valueIsValid($loanTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\LoanType', is_array($loanTypeId) ? implode(', ', $loanTypeId) : var_export($loanTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\LoanType::getValidValues())), __LINE__);
        }
        $this->LoanTypeId = $loanTypeId;
        return $this;
    }
    /**
     * Get MaturityDate value
     * @return string
     */
    public function getMaturityDate()
    {
        return $this->MaturityDate;
    }
    /**
     * Set MaturityDate value
     * @param string $maturityDate
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setMaturityDate($maturityDate = null)
    {
        // validation for constraint: string
        if (!is_null($maturityDate) && !is_string($maturityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maturityDate, true), gettype($maturityDate)), __LINE__);
        }
        $this->MaturityDate = $maturityDate;
        return $this;
    }
    /**
     * Get SingleProgressiveTypeFlag value
     * @return bool
     */
    public function getSingleProgressiveTypeFlag()
    {
        return $this->SingleProgressiveTypeFlag;
    }
    /**
     * Set SingleProgressiveTypeFlag value
     * @param bool $singleProgressiveTypeFlag
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setSingleProgressiveTypeFlag($singleProgressiveTypeFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($singleProgressiveTypeFlag) && !is_bool($singleProgressiveTypeFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($singleProgressiveTypeFlag, true), gettype($singleProgressiveTypeFlag)), __LINE__);
        }
        $this->SingleProgressiveTypeFlag = $singleProgressiveTypeFlag;
        return $this;
    }
    /**
     * Get Rate value
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param \TurnedAwayBOSS\StructType\Rate $rate
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setRate(\TurnedAwayBOSS\StructType\Rate $rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get InterestTypeId value
     * @return string
     */
    public function getInterestTypeId()
    {
        return $this->InterestTypeId;
    }
    /**
     * Set InterestTypeId value
     * @uses \TurnedAwayBOSS\EnumType\InterestType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\InterestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interestTypeId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInterestTypeId($interestTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\InterestType::valueIsValid($interestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\InterestType', is_array($interestTypeId) ? implode(', ', $interestTypeId) : var_export($interestTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\InterestType::getValidValues())), __LINE__);
        }
        $this->InterestTypeId = $interestTypeId;
        return $this;
    }
    /**
     * Get PaymentTermId value
     * @return string
     */
    public function getPaymentTermId()
    {
        return $this->PaymentTermId;
    }
    /**
     * Set PaymentTermId value
     * @uses \TurnedAwayBOSS\EnumType\PaymentTerm::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PaymentTerm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentTermId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setPaymentTermId($paymentTermId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PaymentTerm::valueIsValid($paymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PaymentTerm', is_array($paymentTermId) ? implode(', ', $paymentTermId) : var_export($paymentTermId, true), implode(', ', \TurnedAwayBOSS\EnumType\PaymentTerm::getValidValues())), __LINE__);
        }
        $this->PaymentTermId = $paymentTermId;
        return $this;
    }
    /**
     * Get PaymentFrequencyId value
     * @return string
     */
    public function getPaymentFrequencyId()
    {
        return $this->PaymentFrequencyId;
    }
    /**
     * Set PaymentFrequencyId value
     * @uses \TurnedAwayBOSS\EnumType\PaymentFrequency::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PaymentFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFrequencyId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setPaymentFrequencyId($paymentFrequencyId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PaymentFrequency::valueIsValid($paymentFrequencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PaymentFrequency', is_array($paymentFrequencyId) ? implode(', ', $paymentFrequencyId) : var_export($paymentFrequencyId, true), implode(', ', \TurnedAwayBOSS\EnumType\PaymentFrequency::getValidValues())), __LINE__);
        }
        $this->PaymentFrequencyId = $paymentFrequencyId;
        return $this;
    }
    /**
     * Get InterestCompoundId value
     * @return string
     */
    public function getInterestCompoundId()
    {
        return $this->InterestCompoundId;
    }
    /**
     * Set InterestCompoundId value
     * @uses \TurnedAwayBOSS\EnumType\InterestCompound::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\InterestCompound::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interestCompoundId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInterestCompoundId($interestCompoundId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\InterestCompound::valueIsValid($interestCompoundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\InterestCompound', is_array($interestCompoundId) ? implode(', ', $interestCompoundId) : var_export($interestCompoundId, true), implode(', ', \TurnedAwayBOSS\EnumType\InterestCompound::getValidValues())), __LINE__);
        }
        $this->InterestCompoundId = $interestCompoundId;
        return $this;
    }
    /**
     * Get ActualPaymentTerm value
     * @return int
     */
    public function getActualPaymentTerm()
    {
        return $this->ActualPaymentTerm;
    }
    /**
     * Set ActualPaymentTerm value
     * @param int $actualPaymentTerm
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setActualPaymentTerm($actualPaymentTerm = null)
    {
        // validation for constraint: int
        if (!is_null($actualPaymentTerm) && !(is_int($actualPaymentTerm) || ctype_digit($actualPaymentTerm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actualPaymentTerm, true), gettype($actualPaymentTerm)), __LINE__);
        }
        $this->ActualPaymentTerm = $actualPaymentTerm;
        return $this;
    }
    /**
     * Get AmortizationTerm value
     * @return int
     */
    public function getAmortizationTerm()
    {
        return $this->AmortizationTerm;
    }
    /**
     * Set AmortizationTerm value
     * @param int $amortizationTerm
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setAmortizationTerm($amortizationTerm = null)
    {
        // validation for constraint: int
        if (!is_null($amortizationTerm) && !(is_int($amortizationTerm) || ctype_digit($amortizationTerm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amortizationTerm, true), gettype($amortizationTerm)), __LINE__);
        }
        $this->AmortizationTerm = $amortizationTerm;
        return $this;
    }
    /**
     * Get InterestOnlyFlag value
     * @return bool
     */
    public function getInterestOnlyFlag()
    {
        return $this->InterestOnlyFlag;
    }
    /**
     * Set InterestOnlyFlag value
     * @param bool $interestOnlyFlag
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInterestOnlyFlag($interestOnlyFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($interestOnlyFlag) && !is_bool($interestOnlyFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interestOnlyFlag, true), gettype($interestOnlyFlag)), __LINE__);
        }
        $this->InterestOnlyFlag = $interestOnlyFlag;
        return $this;
    }
    /**
     * Get RefiBlendedAmortization value
     * @return bool
     */
    public function getRefiBlendedAmortization()
    {
        return $this->RefiBlendedAmortization;
    }
    /**
     * Set RefiBlendedAmortization value
     * @param bool $refiBlendedAmortization
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setRefiBlendedAmortization($refiBlendedAmortization = null)
    {
        // validation for constraint: boolean
        if (!is_null($refiBlendedAmortization) && !is_bool($refiBlendedAmortization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refiBlendedAmortization, true), gettype($refiBlendedAmortization)), __LINE__);
        }
        $this->RefiBlendedAmortization = $refiBlendedAmortization;
        return $this;
    }
    /**
     * Get Insurer value
     * @return string
     */
    public function getInsurer()
    {
        return $this->Insurer;
    }
    /**
     * Set Insurer value
     * @uses \TurnedAwayBOSS\EnumType\InsurerType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\InsurerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insurer
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInsurer($insurer = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\InsurerType::valueIsValid($insurer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\InsurerType', is_array($insurer) ? implode(', ', $insurer) : var_export($insurer, true), implode(', ', \TurnedAwayBOSS\EnumType\InsurerType::getValidValues())), __LINE__);
        }
        $this->Insurer = $insurer;
        return $this;
    }
    /**
     * Get MtgInsIncludeFlag value
     * @return bool
     */
    public function getMtgInsIncludeFlag()
    {
        return $this->MtgInsIncludeFlag;
    }
    /**
     * Set MtgInsIncludeFlag value
     * @param bool $mtgInsIncludeFlag
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setMtgInsIncludeFlag($mtgInsIncludeFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($mtgInsIncludeFlag) && !is_bool($mtgInsIncludeFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mtgInsIncludeFlag, true), gettype($mtgInsIncludeFlag)), __LINE__);
        }
        $this->MtgInsIncludeFlag = $mtgInsIncludeFlag;
        return $this;
    }
    /**
     * Get InsPrimeRateOverrideFlag value
     * @return bool
     */
    public function getInsPrimeRateOverrideFlag()
    {
        return $this->InsPrimeRateOverrideFlag;
    }
    /**
     * Set InsPrimeRateOverrideFlag value
     * @param bool $insPrimeRateOverrideFlag
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInsPrimeRateOverrideFlag($insPrimeRateOverrideFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($insPrimeRateOverrideFlag) && !is_bool($insPrimeRateOverrideFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insPrimeRateOverrideFlag, true), gettype($insPrimeRateOverrideFlag)), __LINE__);
        }
        $this->InsPrimeRateOverrideFlag = $insPrimeRateOverrideFlag;
        return $this;
    }
    /**
     * Get InsPrimeRate value
     * @return float
     */
    public function getInsPrimeRate()
    {
        return $this->InsPrimeRate;
    }
    /**
     * Set InsPrimeRate value
     * @param float $insPrimeRate
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInsPrimeRate($insPrimeRate = null)
    {
        // validation for constraint: float
        if (!is_null($insPrimeRate) && !(is_float($insPrimeRate) || is_numeric($insPrimeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insPrimeRate, true), gettype($insPrimeRate)), __LINE__);
        }
        $this->InsPrimeRate = $insPrimeRate;
        return $this;
    }
    /**
     * Get InsMortgagePremium value
     * @return float
     */
    public function getInsMortgagePremium()
    {
        return $this->InsMortgagePremium;
    }
    /**
     * Set InsMortgagePremium value
     * @param float $insMortgagePremium
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setInsMortgagePremium($insMortgagePremium = null)
    {
        // validation for constraint: float
        if (!is_null($insMortgagePremium) && !(is_float($insMortgagePremium) || is_numeric($insMortgagePremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insMortgagePremium, true), gettype($insMortgagePremium)), __LINE__);
        }
        $this->InsMortgagePremium = $insMortgagePremium;
        return $this;
    }
    /**
     * Get LocRepaymentTypeId value
     * @return string
     */
    public function getLocRepaymentTypeId()
    {
        return $this->LocRepaymentTypeId;
    }
    /**
     * Set LocRepaymentTypeId value
     * @uses \TurnedAwayBOSS\EnumType\LocRepaymentType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\LocRepaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locRepaymentTypeId
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setLocRepaymentTypeId($locRepaymentTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\LocRepaymentType::valueIsValid($locRepaymentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\LocRepaymentType', is_array($locRepaymentTypeId) ? implode(', ', $locRepaymentTypeId) : var_export($locRepaymentTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\LocRepaymentType::getValidValues())), __LINE__);
        }
        $this->LocRepaymentTypeId = $locRepaymentTypeId;
        return $this;
    }
    /**
     * Get CashBackOverride value
     * @return bool
     */
    public function getCashBackOverride()
    {
        return $this->CashBackOverride;
    }
    /**
     * Set CashBackOverride value
     * @param bool $cashBackOverride
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setCashBackOverride($cashBackOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashBackOverride) && !is_bool($cashBackOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashBackOverride, true), gettype($cashBackOverride)), __LINE__);
        }
        $this->CashBackOverride = $cashBackOverride;
        return $this;
    }
    /**
     * Get CashBackPercentage value
     * @return float
     */
    public function getCashBackPercentage()
    {
        return $this->CashBackPercentage;
    }
    /**
     * Set CashBackPercentage value
     * @param float $cashBackPercentage
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setCashBackPercentage($cashBackPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($cashBackPercentage) && !(is_float($cashBackPercentage) || is_numeric($cashBackPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashBackPercentage, true), gettype($cashBackPercentage)), __LINE__);
        }
        $this->CashBackPercentage = $cashBackPercentage;
        return $this;
    }
    /**
     * Get CashBackAmt value
     * @return float
     */
    public function getCashBackAmt()
    {
        return $this->CashBackAmt;
    }
    /**
     * Set CashBackAmt value
     * @param float $cashBackAmt
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setCashBackAmt($cashBackAmt = null)
    {
        // validation for constraint: float
        if (!is_null($cashBackAmt) && !(is_float($cashBackAmt) || is_numeric($cashBackAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashBackAmt, true), gettype($cashBackAmt)), __LINE__);
        }
        $this->CashBackAmt = $cashBackAmt;
        return $this;
    }
    /**
     * Get FirstPaymentDate value
     * @return string
     */
    public function getFirstPaymentDate()
    {
        return $this->FirstPaymentDate;
    }
    /**
     * Set FirstPaymentDate value
     * @param string $firstPaymentDate
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public function setFirstPaymentDate($firstPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstPaymentDate) && !is_string($firstPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPaymentDate, true), gettype($firstPaymentDate)), __LINE__);
        }
        $this->FirstPaymentDate = $firstPaymentDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\MortgageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
