<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Liability StructType
 * @subpackage Structs
 */
class Liability extends AbstractStructBase
{
    /**
     * The CreditLimit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CreditLimit;
    /**
     * The LiabilityAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LiabilityAmount;
    /**
     * The LiabilityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LiabilityDescription;
    /**
     * The LiabilityMonthlyPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LiabilityMonthlyPayment;
    /**
     * The LiabilityPayOffTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LiabilityPayOffTypeId;
    /**
     * The LiabilityTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LiabilityTypeId;
    /**
     * The MaturityDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaturityDate;
    /**
     * Constructor method for Liability
     * @uses Liability::setCreditLimit()
     * @uses Liability::setLiabilityAmount()
     * @uses Liability::setLiabilityDescription()
     * @uses Liability::setLiabilityMonthlyPayment()
     * @uses Liability::setLiabilityPayOffTypeId()
     * @uses Liability::setLiabilityTypeId()
     * @uses Liability::setMaturityDate()
     * @param float $creditLimit
     * @param float $liabilityAmount
     * @param string $liabilityDescription
     * @param float $liabilityMonthlyPayment
     * @param string $liabilityPayOffTypeId
     * @param string $liabilityTypeId
     * @param string $maturityDate
     */
    public function __construct($creditLimit = null, $liabilityAmount = null, $liabilityDescription = null, $liabilityMonthlyPayment = null, $liabilityPayOffTypeId = null, $liabilityTypeId = null, $maturityDate = null)
    {
        $this
            ->setCreditLimit($creditLimit)
            ->setLiabilityAmount($liabilityAmount)
            ->setLiabilityDescription($liabilityDescription)
            ->setLiabilityMonthlyPayment($liabilityMonthlyPayment)
            ->setLiabilityPayOffTypeId($liabilityPayOffTypeId)
            ->setLiabilityTypeId($liabilityTypeId)
            ->setMaturityDate($maturityDate);
    }
    /**
     * Get CreditLimit value
     * @return float
     */
    public function getCreditLimit()
    {
        return $this->CreditLimit;
    }
    /**
     * Set CreditLimit value
     * @param float $creditLimit
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->CreditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get LiabilityAmount value
     * @return float
     */
    public function getLiabilityAmount()
    {
        return $this->LiabilityAmount;
    }
    /**
     * Set LiabilityAmount value
     * @param float $liabilityAmount
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setLiabilityAmount($liabilityAmount = null)
    {
        // validation for constraint: float
        if (!is_null($liabilityAmount) && !(is_float($liabilityAmount) || is_numeric($liabilityAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($liabilityAmount, true), gettype($liabilityAmount)), __LINE__);
        }
        $this->LiabilityAmount = $liabilityAmount;
        return $this;
    }
    /**
     * Get LiabilityDescription value
     * @return string
     */
    public function getLiabilityDescription()
    {
        return $this->LiabilityDescription;
    }
    /**
     * Set LiabilityDescription value
     * @param string $liabilityDescription
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setLiabilityDescription($liabilityDescription = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityDescription) && !is_string($liabilityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityDescription, true), gettype($liabilityDescription)), __LINE__);
        }
        $this->LiabilityDescription = $liabilityDescription;
        return $this;
    }
    /**
     * Get LiabilityMonthlyPayment value
     * @return float
     */
    public function getLiabilityMonthlyPayment()
    {
        return $this->LiabilityMonthlyPayment;
    }
    /**
     * Set LiabilityMonthlyPayment value
     * @param float $liabilityMonthlyPayment
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setLiabilityMonthlyPayment($liabilityMonthlyPayment = null)
    {
        // validation for constraint: float
        if (!is_null($liabilityMonthlyPayment) && !(is_float($liabilityMonthlyPayment) || is_numeric($liabilityMonthlyPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($liabilityMonthlyPayment, true), gettype($liabilityMonthlyPayment)), __LINE__);
        }
        $this->LiabilityMonthlyPayment = $liabilityMonthlyPayment;
        return $this;
    }
    /**
     * Get LiabilityPayOffTypeId value
     * @return string
     */
    public function getLiabilityPayOffTypeId()
    {
        return $this->LiabilityPayOffTypeId;
    }
    /**
     * Set LiabilityPayOffTypeId value
     * @uses \TurnedAwayBOSS\EnumType\PayOffType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PayOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liabilityPayOffTypeId
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setLiabilityPayOffTypeId($liabilityPayOffTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PayOffType::valueIsValid($liabilityPayOffTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PayOffType', is_array($liabilityPayOffTypeId) ? implode(', ', $liabilityPayOffTypeId) : var_export($liabilityPayOffTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\PayOffType::getValidValues())), __LINE__);
        }
        $this->LiabilityPayOffTypeId = $liabilityPayOffTypeId;
        return $this;
    }
    /**
     * Get LiabilityTypeId value
     * @return string
     */
    public function getLiabilityTypeId()
    {
        return $this->LiabilityTypeId;
    }
    /**
     * Set LiabilityTypeId value
     * @uses \TurnedAwayBOSS\EnumType\LiabilityType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\LiabilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liabilityTypeId
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setLiabilityTypeId($liabilityTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\LiabilityType::valueIsValid($liabilityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\LiabilityType', is_array($liabilityTypeId) ? implode(', ', $liabilityTypeId) : var_export($liabilityTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\LiabilityType::getValidValues())), __LINE__);
        }
        $this->LiabilityTypeId = $liabilityTypeId;
        return $this;
    }
    /**
     * Get MaturityDate value
     * @return string
     */
    public function getMaturityDate()
    {
        return $this->MaturityDate;
    }
    /**
     * Set MaturityDate value
     * @param string $maturityDate
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public function setMaturityDate($maturityDate = null)
    {
        // validation for constraint: string
        if (!is_null($maturityDate) && !is_string($maturityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maturityDate, true), gettype($maturityDate)), __LINE__);
        }
        $this->MaturityDate = $maturityDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Liability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
