<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeadWorkflow StructType
 * @subpackage Structs
 */
class LeadWorkflow extends AbstractStructBase
{
    /**
     * The LeadDealId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LeadDealId;
    /**
     * The NetworkId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NetworkId;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Brand;
    /**
     * The DealSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealSourceId;
    /**
     * The CreditBureauConsent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreditBureauConsent;
    /**
     * The LeadType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LeadType;
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Authentication;
    /**
     * The casl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $casl;
    /**
     * Constructor method for LeadWorkflow
     * @uses LeadWorkflow::setLeadDealId()
     * @uses LeadWorkflow::setNetworkId()
     * @uses LeadWorkflow::setBrand()
     * @uses LeadWorkflow::setDealSourceId()
     * @uses LeadWorkflow::setCreditBureauConsent()
     * @uses LeadWorkflow::setLeadType()
     * @uses LeadWorkflow::setAuthentication()
     * @uses LeadWorkflow::setCasl()
     * @param string $leadDealId
     * @param int $networkId
     * @param string $brand
     * @param int $dealSourceId
     * @param string $creditBureauConsent
     * @param string $leadType
     * @param string $authentication
     * @param bool $casl
     */
    public function __construct($leadDealId = null, $networkId = null, $brand = null, $dealSourceId = null, $creditBureauConsent = null, $leadType = null, $authentication = null, $casl = null)
    {
        $this
            ->setLeadDealId($leadDealId)
            ->setNetworkId($networkId)
            ->setBrand($brand)
            ->setDealSourceId($dealSourceId)
            ->setCreditBureauConsent($creditBureauConsent)
            ->setLeadType($leadType)
            ->setAuthentication($authentication)
            ->setCasl($casl);
    }
    /**
     * Get LeadDealId value
     * @return string
     */
    public function getLeadDealId()
    {
        return $this->LeadDealId;
    }
    /**
     * Set LeadDealId value
     * @param string $leadDealId
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setLeadDealId($leadDealId = null)
    {
        // validation for constraint: string
        if (!is_null($leadDealId) && !is_string($leadDealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadDealId, true), gettype($leadDealId)), __LINE__);
        }
        $this->LeadDealId = $leadDealId;
        return $this;
    }
    /**
     * Get NetworkId value
     * @return int
     */
    public function getNetworkId()
    {
        return $this->NetworkId;
    }
    /**
     * Set NetworkId value
     * @param int $networkId
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: int
        if (!is_null($networkId) && !(is_int($networkId) || ctype_digit($networkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        $this->NetworkId = $networkId;
        return $this;
    }
    /**
     * Get Brand value
     * @return string
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get DealSourceId value
     * @return int
     */
    public function getDealSourceId()
    {
        return $this->DealSourceId;
    }
    /**
     * Set DealSourceId value
     * @param int $dealSourceId
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setDealSourceId($dealSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($dealSourceId) && !(is_int($dealSourceId) || ctype_digit($dealSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealSourceId, true), gettype($dealSourceId)), __LINE__);
        }
        $this->DealSourceId = $dealSourceId;
        return $this;
    }
    /**
     * Get CreditBureauConsent value
     * @return string
     */
    public function getCreditBureauConsent()
    {
        return $this->CreditBureauConsent;
    }
    /**
     * Set CreditBureauConsent value
     * @uses \TurnedAwayBOSS\EnumType\CreditBureauConsent::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\CreditBureauConsent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditBureauConsent
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setCreditBureauConsent($creditBureauConsent = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\CreditBureauConsent::valueIsValid($creditBureauConsent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\CreditBureauConsent', is_array($creditBureauConsent) ? implode(', ', $creditBureauConsent) : var_export($creditBureauConsent, true), implode(', ', \TurnedAwayBOSS\EnumType\CreditBureauConsent::getValidValues())), __LINE__);
        }
        $this->CreditBureauConsent = $creditBureauConsent;
        return $this;
    }
    /**
     * Get LeadType value
     * @return string
     */
    public function getLeadType()
    {
        return $this->LeadType;
    }
    /**
     * Set LeadType value
     * @uses \TurnedAwayBOSS\EnumType\LeadType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\LeadType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $leadType
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setLeadType($leadType = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\LeadType::valueIsValid($leadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\LeadType', is_array($leadType) ? implode(', ', $leadType) : var_export($leadType, true), implode(', ', \TurnedAwayBOSS\EnumType\LeadType::getValidValues())), __LINE__);
        }
        $this->LeadType = $leadType;
        return $this;
    }
    /**
     * Get Authentication value
     * @return string
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @uses \TurnedAwayBOSS\EnumType\Authentication::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Authentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authentication
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setAuthentication($authentication = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Authentication::valueIsValid($authentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Authentication', is_array($authentication) ? implode(', ', $authentication) : var_export($authentication, true), implode(', ', \TurnedAwayBOSS\EnumType\Authentication::getValidValues())), __LINE__);
        }
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get casl value
     * @return bool
     */
    public function getCasl()
    {
        return $this->casl;
    }
    /**
     * Set casl value
     * @param bool $casl
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function setCasl($casl = null)
    {
        // validation for constraint: boolean
        if (!is_null($casl) && !is_bool($casl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($casl, true), gettype($casl)), __LINE__);
        }
        $this->casl = $casl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
