<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Income StructType
 * @subpackage Structs
 */
class Income extends AbstractStructBase
{
    /**
     * The IncomeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $IncomeAmount;
    /**
     * The IncomePeriodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IncomePeriodId;
    /**
     * The IncomeTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IncomeTypeId;
    /**
     * Constructor method for Income
     * @uses Income::setIncomeAmount()
     * @uses Income::setIncomePeriodId()
     * @uses Income::setIncomeTypeId()
     * @param float $incomeAmount
     * @param string $incomePeriodId
     * @param string $incomeTypeId
     */
    public function __construct($incomeAmount = null, $incomePeriodId = null, $incomeTypeId = null)
    {
        $this
            ->setIncomeAmount($incomeAmount)
            ->setIncomePeriodId($incomePeriodId)
            ->setIncomeTypeId($incomeTypeId);
    }
    /**
     * Get IncomeAmount value
     * @return float
     */
    public function getIncomeAmount()
    {
        return $this->IncomeAmount;
    }
    /**
     * Set IncomeAmount value
     * @param float $incomeAmount
     * @return \TurnedAwayBOSS\StructType\Income
     */
    public function setIncomeAmount($incomeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($incomeAmount) && !(is_float($incomeAmount) || is_numeric($incomeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incomeAmount, true), gettype($incomeAmount)), __LINE__);
        }
        $this->IncomeAmount = $incomeAmount;
        return $this;
    }
    /**
     * Get IncomePeriodId value
     * @return string
     */
    public function getIncomePeriodId()
    {
        return $this->IncomePeriodId;
    }
    /**
     * Set IncomePeriodId value
     * @uses \TurnedAwayBOSS\EnumType\Period::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Period::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomePeriodId
     * @return \TurnedAwayBOSS\StructType\Income
     */
    public function setIncomePeriodId($incomePeriodId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Period::valueIsValid($incomePeriodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Period', is_array($incomePeriodId) ? implode(', ', $incomePeriodId) : var_export($incomePeriodId, true), implode(', ', \TurnedAwayBOSS\EnumType\Period::getValidValues())), __LINE__);
        }
        $this->IncomePeriodId = $incomePeriodId;
        return $this;
    }
    /**
     * Get IncomeTypeId value
     * @return string
     */
    public function getIncomeTypeId()
    {
        return $this->IncomeTypeId;
    }
    /**
     * Set IncomeTypeId value
     * @uses \TurnedAwayBOSS\EnumType\IncomeType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\IncomeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomeTypeId
     * @return \TurnedAwayBOSS\StructType\Income
     */
    public function setIncomeTypeId($incomeTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\IncomeType::valueIsValid($incomeTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\IncomeType', is_array($incomeTypeId) ? implode(', ', $incomeTypeId) : var_export($incomeTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\IncomeType::getValidValues())), __LINE__);
        }
        $this->IncomeTypeId = $incomeTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Income
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
