<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNetworkAndBrand StructType
 * @subpackage Structs
 */
class GetNetworkAndBrand extends AbstractStructBase
{
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Token;
    /**
     * The province
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $province;
    /**
     * The langId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $langId;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * Constructor method for GetNetworkAndBrand
     * @uses GetNetworkAndBrand::setToken()
     * @uses GetNetworkAndBrand::setProvince()
     * @uses GetNetworkAndBrand::setLangId()
     * @uses GetNetworkAndBrand::setPostalCode()
     * @param string $token
     * @param string $province
     * @param string $langId
     * @param string $postalCode
     */
    public function __construct($token = null, $province = null, $langId = null, $postalCode = null)
    {
        $this
            ->setToken($token)
            ->setProvince($province)
            ->setLangId($langId)
            ->setPostalCode($postalCode);
    }
    /**
     * Get Token value
     * @return string
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrand
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($token) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($token, true)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get province value
     * @return string
     */
    public function getProvince()
    {
        return $this->province;
    }
    /**
     * Set province value
     * @uses \TurnedAwayBOSS\EnumType\ProvinceId::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ProvinceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $province
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrand
     */
    public function setProvince($province = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ProvinceId::valueIsValid($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ProvinceId', is_array($province) ? implode(', ', $province) : var_export($province, true), implode(', ', \TurnedAwayBOSS\EnumType\ProvinceId::getValidValues())), __LINE__);
        }
        $this->province = $province;
        return $this;
    }
    /**
     * Get langId value
     * @return string
     */
    public function getLangId()
    {
        return $this->langId;
    }
    /**
     * Set langId value
     * @uses \TurnedAwayBOSS\EnumType\Language::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $langId
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrand
     */
    public function setLangId($langId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Language::valueIsValid($langId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Language', is_array($langId) ? implode(', ', $langId) : var_export($langId, true), implode(', ', \TurnedAwayBOSS\EnumType\Language::getValidValues())), __LINE__);
        }
        $this->langId = $langId;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrand
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
