<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownPayment StructType
 * @subpackage Structs
 */
class DownPayment extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The SourceTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SourceTypeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for DownPayment
     * @uses DownPayment::setAmount()
     * @uses DownPayment::setSourceTypeId()
     * @uses DownPayment::setDescription()
     * @param float $amount
     * @param string $sourceTypeId
     * @param string $description
     */
    public function __construct($amount = null, $sourceTypeId = null, $description = null)
    {
        $this
            ->setAmount($amount)
            ->setSourceTypeId($sourceTypeId)
            ->setDescription($description);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \TurnedAwayBOSS\StructType\DownPayment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get SourceTypeId value
     * @return string
     */
    public function getSourceTypeId()
    {
        return $this->SourceTypeId;
    }
    /**
     * Set SourceTypeId value
     * @uses \TurnedAwayBOSS\EnumType\SourceType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\SourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceTypeId
     * @return \TurnedAwayBOSS\StructType\DownPayment
     */
    public function setSourceTypeId($sourceTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\SourceType::valueIsValid($sourceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\SourceType', is_array($sourceTypeId) ? implode(', ', $sourceTypeId) : var_export($sourceTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\SourceType::getValidValues())), __LINE__);
        }
        $this->SourceTypeId = $sourceTypeId;
        return $this;
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \TurnedAwayBOSS\StructType\DownPayment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\DownPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
