<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealInfo StructType
 * @subpackage Structs
 */
class DealInfo extends AbstractStructBase
{
    /**
     * The DealPurposeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DealPurposeId;
    /**
     * The DealTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DealTypeId;
    /**
     * The RefiPurpose
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RefiPurpose;
    /**
     * The IsCommercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsCommercial;
    /**
     * The RefiImprovementsFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RefiImprovementsFlag;
    /**
     * The RefiImprovementAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RefiImprovementAmount;
    /**
     * The RefiImprovementDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RefiImprovementDesc;
    /**
     * The EstimatedClosingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedClosingDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The PurchaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PurchaseDate;
    /**
     * The PurchaseDateCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PurchaseDateCategory;
    /**
     * The DownPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment
     */
    public $DownPayments;
    /**
     * Constructor method for DealInfo
     * @uses DealInfo::setDealPurposeId()
     * @uses DealInfo::setDealTypeId()
     * @uses DealInfo::setRefiPurpose()
     * @uses DealInfo::setIsCommercial()
     * @uses DealInfo::setRefiImprovementsFlag()
     * @uses DealInfo::setRefiImprovementAmount()
     * @uses DealInfo::setRefiImprovementDesc()
     * @uses DealInfo::setEstimatedClosingDate()
     * @uses DealInfo::setDescription()
     * @uses DealInfo::setPurchaseDate()
     * @uses DealInfo::setPurchaseDateCategory()
     * @uses DealInfo::setDownPayments()
     * @param string $dealPurposeId
     * @param string $dealTypeId
     * @param string $refiPurpose
     * @param bool $isCommercial
     * @param bool $refiImprovementsFlag
     * @param float $refiImprovementAmount
     * @param string $refiImprovementDesc
     * @param string $estimatedClosingDate
     * @param string $description
     * @param string $purchaseDate
     * @param string $purchaseDateCategory
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment $downPayments
     */
    public function __construct($dealPurposeId = null, $dealTypeId = null, $refiPurpose = null, $isCommercial = null, $refiImprovementsFlag = null, $refiImprovementAmount = null, $refiImprovementDesc = null, $estimatedClosingDate = null, $description = null, $purchaseDate = null, $purchaseDateCategory = null, \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment $downPayments = null)
    {
        $this
            ->setDealPurposeId($dealPurposeId)
            ->setDealTypeId($dealTypeId)
            ->setRefiPurpose($refiPurpose)
            ->setIsCommercial($isCommercial)
            ->setRefiImprovementsFlag($refiImprovementsFlag)
            ->setRefiImprovementAmount($refiImprovementAmount)
            ->setRefiImprovementDesc($refiImprovementDesc)
            ->setEstimatedClosingDate($estimatedClosingDate)
            ->setDescription($description)
            ->setPurchaseDate($purchaseDate)
            ->setPurchaseDateCategory($purchaseDateCategory)
            ->setDownPayments($downPayments);
    }
    /**
     * Get DealPurposeId value
     * @return string
     */
    public function getDealPurposeId()
    {
        return $this->DealPurposeId;
    }
    /**
     * Set DealPurposeId value
     * @uses \TurnedAwayBOSS\EnumType\DealPurpose::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\DealPurpose::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dealPurposeId
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setDealPurposeId($dealPurposeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\DealPurpose::valueIsValid($dealPurposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\DealPurpose', is_array($dealPurposeId) ? implode(', ', $dealPurposeId) : var_export($dealPurposeId, true), implode(', ', \TurnedAwayBOSS\EnumType\DealPurpose::getValidValues())), __LINE__);
        }
        $this->DealPurposeId = $dealPurposeId;
        return $this;
    }
    /**
     * Get DealTypeId value
     * @return string
     */
    public function getDealTypeId()
    {
        return $this->DealTypeId;
    }
    /**
     * Set DealTypeId value
     * @uses \TurnedAwayBOSS\EnumType\DealType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\DealType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dealTypeId
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setDealTypeId($dealTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\DealType::valueIsValid($dealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\DealType', is_array($dealTypeId) ? implode(', ', $dealTypeId) : var_export($dealTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\DealType::getValidValues())), __LINE__);
        }
        $this->DealTypeId = $dealTypeId;
        return $this;
    }
    /**
     * Get RefiPurpose value
     * @return string
     */
    public function getRefiPurpose()
    {
        return $this->RefiPurpose;
    }
    /**
     * Set RefiPurpose value
     * @param string $refiPurpose
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setRefiPurpose($refiPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($refiPurpose) && !is_string($refiPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refiPurpose, true), gettype($refiPurpose)), __LINE__);
        }
        $this->RefiPurpose = $refiPurpose;
        return $this;
    }
    /**
     * Get IsCommercial value
     * @return bool
     */
    public function getIsCommercial()
    {
        return $this->IsCommercial;
    }
    /**
     * Set IsCommercial value
     * @param bool $isCommercial
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setIsCommercial($isCommercial = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommercial) && !is_bool($isCommercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommercial, true), gettype($isCommercial)), __LINE__);
        }
        $this->IsCommercial = $isCommercial;
        return $this;
    }
    /**
     * Get RefiImprovementsFlag value
     * @return bool
     */
    public function getRefiImprovementsFlag()
    {
        return $this->RefiImprovementsFlag;
    }
    /**
     * Set RefiImprovementsFlag value
     * @param bool $refiImprovementsFlag
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setRefiImprovementsFlag($refiImprovementsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($refiImprovementsFlag) && !is_bool($refiImprovementsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refiImprovementsFlag, true), gettype($refiImprovementsFlag)), __LINE__);
        }
        $this->RefiImprovementsFlag = $refiImprovementsFlag;
        return $this;
    }
    /**
     * Get RefiImprovementAmount value
     * @return float
     */
    public function getRefiImprovementAmount()
    {
        return $this->RefiImprovementAmount;
    }
    /**
     * Set RefiImprovementAmount value
     * @param float $refiImprovementAmount
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setRefiImprovementAmount($refiImprovementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($refiImprovementAmount) && !(is_float($refiImprovementAmount) || is_numeric($refiImprovementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refiImprovementAmount, true), gettype($refiImprovementAmount)), __LINE__);
        }
        $this->RefiImprovementAmount = $refiImprovementAmount;
        return $this;
    }
    /**
     * Get RefiImprovementDesc value
     * @return string
     */
    public function getRefiImprovementDesc()
    {
        return $this->RefiImprovementDesc;
    }
    /**
     * Set RefiImprovementDesc value
     * @param string $refiImprovementDesc
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setRefiImprovementDesc($refiImprovementDesc = null)
    {
        // validation for constraint: string
        if (!is_null($refiImprovementDesc) && !is_string($refiImprovementDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refiImprovementDesc, true), gettype($refiImprovementDesc)), __LINE__);
        }
        $this->RefiImprovementDesc = $refiImprovementDesc;
        return $this;
    }
    /**
     * Get EstimatedClosingDate value
     * @return string
     */
    public function getEstimatedClosingDate()
    {
        return $this->EstimatedClosingDate;
    }
    /**
     * Set EstimatedClosingDate value
     * @param string $estimatedClosingDate
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setEstimatedClosingDate($estimatedClosingDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedClosingDate) && !is_string($estimatedClosingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedClosingDate, true), gettype($estimatedClosingDate)), __LINE__);
        }
        $this->EstimatedClosingDate = $estimatedClosingDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PurchaseDate value
     * @return string
     */
    public function getPurchaseDate()
    {
        return $this->PurchaseDate;
    }
    /**
     * Set PurchaseDate value
     * @param string $purchaseDate
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDate) && !is_string($purchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDate, true), gettype($purchaseDate)), __LINE__);
        }
        $this->PurchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get PurchaseDateCategory value
     * @return string
     */
    public function getPurchaseDateCategory()
    {
        return $this->PurchaseDateCategory;
    }
    /**
     * Set PurchaseDateCategory value
     * @param string $purchaseDateCategory
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setPurchaseDateCategory($purchaseDateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDateCategory) && !is_string($purchaseDateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDateCategory, true), gettype($purchaseDateCategory)), __LINE__);
        }
        $this->PurchaseDateCategory = $purchaseDateCategory;
        return $this;
    }
    /**
     * Get DownPayments value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment|null
     */
    public function getDownPayments()
    {
        return $this->DownPayments;
    }
    /**
     * Set DownPayments value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment $downPayments
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function setDownPayments(\TurnedAwayBOSS\ArrayType\ArrayOfDownPayment $downPayments = null)
    {
        $this->DownPayments = $downPayments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
