<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bankruptcy StructType
 * @subpackage Structs
 */
class Bankruptcy extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The DebtAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DebtAmount;
    /**
     * The MonthlyPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MonthlyPayment;
    /**
     * The DeclaredDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeclaredDate;
    /**
     * The DischargedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DischargedDate;
    /**
     * Constructor method for Bankruptcy
     * @uses Bankruptcy::setDetails()
     * @uses Bankruptcy::setDebtAmount()
     * @uses Bankruptcy::setMonthlyPayment()
     * @uses Bankruptcy::setDeclaredDate()
     * @uses Bankruptcy::setDischargedDate()
     * @param string $details
     * @param float $debtAmount
     * @param float $monthlyPayment
     * @param string $declaredDate
     * @param string $dischargedDate
     */
    public function __construct($details = null, $debtAmount = null, $monthlyPayment = null, $declaredDate = null, $dischargedDate = null)
    {
        $this
            ->setDetails($details)
            ->setDebtAmount($debtAmount)
            ->setMonthlyPayment($monthlyPayment)
            ->setDeclaredDate($declaredDate)
            ->setDischargedDate($dischargedDate);
    }
    /**
     * Get Details value
     * @return string
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param string $details
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Get DebtAmount value
     * @return float
     */
    public function getDebtAmount()
    {
        return $this->DebtAmount;
    }
    /**
     * Set DebtAmount value
     * @param float $debtAmount
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public function setDebtAmount($debtAmount = null)
    {
        // validation for constraint: float
        if (!is_null($debtAmount) && !(is_float($debtAmount) || is_numeric($debtAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debtAmount, true), gettype($debtAmount)), __LINE__);
        }
        $this->DebtAmount = $debtAmount;
        return $this;
    }
    /**
     * Get MonthlyPayment value
     * @return float
     */
    public function getMonthlyPayment()
    {
        return $this->MonthlyPayment;
    }
    /**
     * Set MonthlyPayment value
     * @param float $monthlyPayment
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public function setMonthlyPayment($monthlyPayment = null)
    {
        // validation for constraint: float
        if (!is_null($monthlyPayment) && !(is_float($monthlyPayment) || is_numeric($monthlyPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monthlyPayment, true), gettype($monthlyPayment)), __LINE__);
        }
        $this->MonthlyPayment = $monthlyPayment;
        return $this;
    }
    /**
     * Get DeclaredDate value
     * @return string
     */
    public function getDeclaredDate()
    {
        return $this->DeclaredDate;
    }
    /**
     * Set DeclaredDate value
     * @param string $declaredDate
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public function setDeclaredDate($declaredDate = null)
    {
        // validation for constraint: string
        if (!is_null($declaredDate) && !is_string($declaredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredDate, true), gettype($declaredDate)), __LINE__);
        }
        $this->DeclaredDate = $declaredDate;
        return $this;
    }
    /**
     * Get DischargedDate value
     * @return string
     */
    public function getDischargedDate()
    {
        return $this->DischargedDate;
    }
    /**
     * Set DischargedDate value
     * @param string $dischargedDate
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public function setDischargedDate($dischargedDate = null)
    {
        // validation for constraint: string
        if (!is_null($dischargedDate) && !is_string($dischargedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dischargedDate, true), gettype($dischargedDate)), __LINE__);
        }
        $this->DischargedDate = $dischargedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Bankruptcy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
