<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicantProperty StructType
 * @subpackage Structs
 */
class ApplicantProperty extends AbstractStructBase
{
    /**
     * The OccupancyTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OccupancyTypeId;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Address
     */
    public $Address;
    /**
     * The EstimatedAppraisalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EstimatedAppraisalValue;
    /**
     * The OriginalPurchasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OriginalPurchasePrice;
    /**
     * The RefiOriginalPurchaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RefiOriginalPurchaseDate;
    /**
     * The IsSubjectProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsSubjectProperty;
    /**
     * The IncludeTds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeTds;
    /**
     * The FeesIncludeHeat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FeesIncludeHeat;
    /**
     * The PropertyRentalIncome
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public $PropertyRentalIncome;
    /**
     * The PropertyExpenses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense
     */
    public $PropertyExpenses;
    /**
     * The ExistingMortgages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage
     */
    public $ExistingMortgages;
    /**
     * Constructor method for ApplicantProperty
     * @uses ApplicantProperty::setOccupancyTypeId()
     * @uses ApplicantProperty::setAddress()
     * @uses ApplicantProperty::setEstimatedAppraisalValue()
     * @uses ApplicantProperty::setOriginalPurchasePrice()
     * @uses ApplicantProperty::setRefiOriginalPurchaseDate()
     * @uses ApplicantProperty::setIsSubjectProperty()
     * @uses ApplicantProperty::setIncludeTds()
     * @uses ApplicantProperty::setFeesIncludeHeat()
     * @uses ApplicantProperty::setPropertyRentalIncome()
     * @uses ApplicantProperty::setPropertyExpenses()
     * @uses ApplicantProperty::setExistingMortgages()
     * @param string $occupancyTypeId
     * @param \TurnedAwayBOSS\StructType\Address $address
     * @param float $estimatedAppraisalValue
     * @param float $originalPurchasePrice
     * @param string $refiOriginalPurchaseDate
     * @param bool $isSubjectProperty
     * @param bool $includeTds
     * @param bool $feesIncludeHeat
     * @param \TurnedAwayBOSS\StructType\PropertyRentalIncome $propertyRentalIncome
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense $propertyExpenses
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage $existingMortgages
     */
    public function __construct($occupancyTypeId = null, \TurnedAwayBOSS\StructType\Address $address = null, $estimatedAppraisalValue = null, $originalPurchasePrice = null, $refiOriginalPurchaseDate = null, $isSubjectProperty = null, $includeTds = null, $feesIncludeHeat = null, \TurnedAwayBOSS\StructType\PropertyRentalIncome $propertyRentalIncome = null, \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense $propertyExpenses = null, \TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage $existingMortgages = null)
    {
        $this
            ->setOccupancyTypeId($occupancyTypeId)
            ->setAddress($address)
            ->setEstimatedAppraisalValue($estimatedAppraisalValue)
            ->setOriginalPurchasePrice($originalPurchasePrice)
            ->setRefiOriginalPurchaseDate($refiOriginalPurchaseDate)
            ->setIsSubjectProperty($isSubjectProperty)
            ->setIncludeTds($includeTds)
            ->setFeesIncludeHeat($feesIncludeHeat)
            ->setPropertyRentalIncome($propertyRentalIncome)
            ->setPropertyExpenses($propertyExpenses)
            ->setExistingMortgages($existingMortgages);
    }
    /**
     * Get OccupancyTypeId value
     * @return string
     */
    public function getOccupancyTypeId()
    {
        return $this->OccupancyTypeId;
    }
    /**
     * Set OccupancyTypeId value
     * @uses \TurnedAwayBOSS\EnumType\OccupancyType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\OccupancyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyTypeId
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setOccupancyTypeId($occupancyTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\OccupancyType::valueIsValid($occupancyTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\OccupancyType', is_array($occupancyTypeId) ? implode(', ', $occupancyTypeId) : var_export($occupancyTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\OccupancyType::getValidValues())), __LINE__);
        }
        $this->OccupancyTypeId = $occupancyTypeId;
        return $this;
    }
    /**
     * Get Address value
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \TurnedAwayBOSS\StructType\Address $address
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setAddress(\TurnedAwayBOSS\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EstimatedAppraisalValue value
     * @return float
     */
    public function getEstimatedAppraisalValue()
    {
        return $this->EstimatedAppraisalValue;
    }
    /**
     * Set EstimatedAppraisalValue value
     * @param float $estimatedAppraisalValue
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setEstimatedAppraisalValue($estimatedAppraisalValue = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedAppraisalValue) && !(is_float($estimatedAppraisalValue) || is_numeric($estimatedAppraisalValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedAppraisalValue, true), gettype($estimatedAppraisalValue)), __LINE__);
        }
        $this->EstimatedAppraisalValue = $estimatedAppraisalValue;
        return $this;
    }
    /**
     * Get OriginalPurchasePrice value
     * @return float
     */
    public function getOriginalPurchasePrice()
    {
        return $this->OriginalPurchasePrice;
    }
    /**
     * Set OriginalPurchasePrice value
     * @param float $originalPurchasePrice
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setOriginalPurchasePrice($originalPurchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($originalPurchasePrice) && !(is_float($originalPurchasePrice) || is_numeric($originalPurchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalPurchasePrice, true), gettype($originalPurchasePrice)), __LINE__);
        }
        $this->OriginalPurchasePrice = $originalPurchasePrice;
        return $this;
    }
    /**
     * Get RefiOriginalPurchaseDate value
     * @return string
     */
    public function getRefiOriginalPurchaseDate()
    {
        return $this->RefiOriginalPurchaseDate;
    }
    /**
     * Set RefiOriginalPurchaseDate value
     * @param string $refiOriginalPurchaseDate
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setRefiOriginalPurchaseDate($refiOriginalPurchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($refiOriginalPurchaseDate) && !is_string($refiOriginalPurchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refiOriginalPurchaseDate, true), gettype($refiOriginalPurchaseDate)), __LINE__);
        }
        $this->RefiOriginalPurchaseDate = $refiOriginalPurchaseDate;
        return $this;
    }
    /**
     * Get IsSubjectProperty value
     * @return bool
     */
    public function getIsSubjectProperty()
    {
        return $this->IsSubjectProperty;
    }
    /**
     * Set IsSubjectProperty value
     * @param bool $isSubjectProperty
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setIsSubjectProperty($isSubjectProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubjectProperty) && !is_bool($isSubjectProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubjectProperty, true), gettype($isSubjectProperty)), __LINE__);
        }
        $this->IsSubjectProperty = $isSubjectProperty;
        return $this;
    }
    /**
     * Get IncludeTds value
     * @return bool
     */
    public function getIncludeTds()
    {
        return $this->IncludeTds;
    }
    /**
     * Set IncludeTds value
     * @param bool $includeTds
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setIncludeTds($includeTds = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTds) && !is_bool($includeTds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTds, true), gettype($includeTds)), __LINE__);
        }
        $this->IncludeTds = $includeTds;
        return $this;
    }
    /**
     * Get FeesIncludeHeat value
     * @return bool
     */
    public function getFeesIncludeHeat()
    {
        return $this->FeesIncludeHeat;
    }
    /**
     * Set FeesIncludeHeat value
     * @param bool $feesIncludeHeat
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setFeesIncludeHeat($feesIncludeHeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($feesIncludeHeat) && !is_bool($feesIncludeHeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($feesIncludeHeat, true), gettype($feesIncludeHeat)), __LINE__);
        }
        $this->FeesIncludeHeat = $feesIncludeHeat;
        return $this;
    }
    /**
     * Get PropertyRentalIncome value
     * @return \TurnedAwayBOSS\StructType\PropertyRentalIncome
     */
    public function getPropertyRentalIncome()
    {
        return $this->PropertyRentalIncome;
    }
    /**
     * Set PropertyRentalIncome value
     * @param \TurnedAwayBOSS\StructType\PropertyRentalIncome $propertyRentalIncome
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setPropertyRentalIncome(\TurnedAwayBOSS\StructType\PropertyRentalIncome $propertyRentalIncome = null)
    {
        $this->PropertyRentalIncome = $propertyRentalIncome;
        return $this;
    }
    /**
     * Get PropertyExpenses value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense|null
     */
    public function getPropertyExpenses()
    {
        return $this->PropertyExpenses;
    }
    /**
     * Set PropertyExpenses value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense $propertyExpenses
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setPropertyExpenses(\TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense $propertyExpenses = null)
    {
        $this->PropertyExpenses = $propertyExpenses;
        return $this;
    }
    /**
     * Get ExistingMortgages value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage|null
     */
    public function getExistingMortgages()
    {
        return $this->ExistingMortgages;
    }
    /**
     * Set ExistingMortgages value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage $existingMortgages
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public function setExistingMortgages(\TurnedAwayBOSS\ArrayType\ArrayOfExistingMortgage $existingMortgages = null)
    {
        $this->ExistingMortgages = $existingMortgages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\ApplicantProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
