<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The UnitNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UnitNumber;
    /**
     * The StreetNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StreetNumber;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StreetTypeId;
    /**
     * The StreetDirectionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StreetDirectionId;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The ProvinceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ProvinceId;
    /**
     * The PostalFsa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PostalFsa;
    /**
     * The PostalLdu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PostalLdu;
    /**
     * The CountryTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CountryTypeId;
    /**
     * Constructor method for Address
     * @uses Address::setUnitNumber()
     * @uses Address::setStreetNumber()
     * @uses Address::setStreetName()
     * @uses Address::setStreetTypeId()
     * @uses Address::setStreetDirectionId()
     * @uses Address::setCity()
     * @uses Address::setProvinceId()
     * @uses Address::setPostalFsa()
     * @uses Address::setPostalLdu()
     * @uses Address::setCountryTypeId()
     * @param string $unitNumber
     * @param string $streetNumber
     * @param string $streetName
     * @param string $streetTypeId
     * @param string $streetDirectionId
     * @param string $city
     * @param string $provinceId
     * @param string $postalFsa
     * @param string $postalLdu
     * @param string $countryTypeId
     */
    public function __construct($unitNumber = null, $streetNumber = null, $streetName = null, $streetTypeId = null, $streetDirectionId = null, $city = null, $provinceId = null, $postalFsa = null, $postalLdu = null, $countryTypeId = null)
    {
        $this
            ->setUnitNumber($unitNumber)
            ->setStreetNumber($streetNumber)
            ->setStreetName($streetName)
            ->setStreetTypeId($streetTypeId)
            ->setStreetDirectionId($streetDirectionId)
            ->setCity($city)
            ->setProvinceId($provinceId)
            ->setPostalFsa($postalFsa)
            ->setPostalLdu($postalLdu)
            ->setCountryTypeId($countryTypeId);
    }
    /**
     * Get UnitNumber value
     * @return string
     */
    public function getUnitNumber()
    {
        return $this->UnitNumber;
    }
    /**
     * Set UnitNumber value
     * @param string $unitNumber
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setUnitNumber($unitNumber = null)
    {
        // validation for constraint: string
        if (!is_null($unitNumber) && !is_string($unitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitNumber, true), gettype($unitNumber)), __LINE__);
        }
        $this->UnitNumber = $unitNumber;
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetTypeId value
     * @return string
     */
    public function getStreetTypeId()
    {
        return $this->StreetTypeId;
    }
    /**
     * Set StreetTypeId value
     * @param string $streetTypeId
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setStreetTypeId($streetTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($streetTypeId) && !is_string($streetTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetTypeId, true), gettype($streetTypeId)), __LINE__);
        }
        $this->StreetTypeId = $streetTypeId;
        return $this;
    }
    /**
     * Get StreetDirectionId value
     * @return string
     */
    public function getStreetDirectionId()
    {
        return $this->StreetDirectionId;
    }
    /**
     * Set StreetDirectionId value
     * @uses \TurnedAwayBOSS\EnumType\StreetDirection::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\StreetDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $streetDirectionId
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setStreetDirectionId($streetDirectionId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\StreetDirection::valueIsValid($streetDirectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\StreetDirection', is_array($streetDirectionId) ? implode(', ', $streetDirectionId) : var_export($streetDirectionId, true), implode(', ', \TurnedAwayBOSS\EnumType\StreetDirection::getValidValues())), __LINE__);
        }
        $this->StreetDirectionId = $streetDirectionId;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get ProvinceId value
     * @return string
     */
    public function getProvinceId()
    {
        return $this->ProvinceId;
    }
    /**
     * Set ProvinceId value
     * @uses \TurnedAwayBOSS\EnumType\ProvinceId::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\ProvinceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provinceId
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setProvinceId($provinceId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\ProvinceId::valueIsValid($provinceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\ProvinceId', is_array($provinceId) ? implode(', ', $provinceId) : var_export($provinceId, true), implode(', ', \TurnedAwayBOSS\EnumType\ProvinceId::getValidValues())), __LINE__);
        }
        $this->ProvinceId = $provinceId;
        return $this;
    }
    /**
     * Get PostalFsa value
     * @return string
     */
    public function getPostalFsa()
    {
        return $this->PostalFsa;
    }
    /**
     * Set PostalFsa value
     * @param string $postalFsa
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setPostalFsa($postalFsa = null)
    {
        // validation for constraint: string
        if (!is_null($postalFsa) && !is_string($postalFsa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalFsa, true), gettype($postalFsa)), __LINE__);
        }
        $this->PostalFsa = $postalFsa;
        return $this;
    }
    /**
     * Get PostalLdu value
     * @return string
     */
    public function getPostalLdu()
    {
        return $this->PostalLdu;
    }
    /**
     * Set PostalLdu value
     * @param string $postalLdu
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setPostalLdu($postalLdu = null)
    {
        // validation for constraint: string
        if (!is_null($postalLdu) && !is_string($postalLdu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalLdu, true), gettype($postalLdu)), __LINE__);
        }
        $this->PostalLdu = $postalLdu;
        return $this;
    }
    /**
     * Get CountryTypeId value
     * @return string
     */
    public function getCountryTypeId()
    {
        return $this->CountryTypeId;
    }
    /**
     * Set CountryTypeId value
     * @uses \TurnedAwayBOSS\EnumType\CountryType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryTypeId
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function setCountryTypeId($countryTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\CountryType::valueIsValid($countryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\CountryType', is_array($countryTypeId) ? implode(', ', $countryTypeId) : var_export($countryTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->CountryTypeId = $countryTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
