<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListAvailableDeals
     * Meta information extracted from the WSDL
     * - documentation: Get the list of available deals. / Récupérer la liste des dossiers disponibles.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\ListAvailableDeals $parameters
     * @return \TurnedAwayBOSS\StructType\ListAvailableDealsResponse|bool
     */
    public function ListAvailableDeals(\TurnedAwayBOSS\StructType\ListAvailableDeals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListAvailableDeals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListUpdatedDeals
     * Meta information extracted from the WSDL
     * - documentation: Get the list of updated deals. / Récupérer la liste des dossiers modifiés.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\ListUpdatedDeals $parameters
     * @return \TurnedAwayBOSS\StructType\ListUpdatedDealsResponse|bool
     */
    public function ListUpdatedDeals(\TurnedAwayBOSS\StructType\ListUpdatedDeals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListUpdatedDeals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\ListAvailableDealsResponse|\TurnedAwayBOSS\StructType\ListUpdatedDealsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
