<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recalc ServiceType
 * @subpackage Services
 */
class Recalc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecalcBRE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\RecalcBRE $parameters
     * @return \TurnedAwayBOSS\StructType\RecalcBREResponse|bool
     */
    public function RecalcBRE(\TurnedAwayBOSS\StructType\RecalcBRE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecalcBRE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\RecalcBREResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
