<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Push ServiceType
 * @subpackage Services
 */
class Push extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PushResponse
     * Meta information extracted from the WSDL
     * - documentation: Provide for a specific deal a response with its conditions. / Fournir une réponse et ses conditions pour un dossier soumis.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PushResponse $parameters
     * @return \TurnedAwayBOSS\StructType\PushResponseResponse|bool
     */
    public function PushResponse(\TurnedAwayBOSS\StructType\PushResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PushResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PushDeal
     * Meta information extracted from the WSDL
     * - documentation: Create Deal in Boss Based on BOSS XML and returns a newly created BOSS Deal ID and optional fields requested by Lead Workflows
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\PushDeal $parameters
     * @return \TurnedAwayBOSS\StructType\PushDealResponse|bool
     */
    public function PushDeal(\TurnedAwayBOSS\StructType\PushDeal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PushDeal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\PushDealResponse|\TurnedAwayBOSS\StructType\PushResponseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
