<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetNetworkAndBrand
     * Meta information extracted from the WSDL
     * - documentation: Get an avalible network and brand based on an address
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\GetNetworkAndBrand $parameters
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrandResponse|bool
     */
    public function GetNetworkAndBrand(\TurnedAwayBOSS\StructType\GetNetworkAndBrand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNetworkAndBrand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\GetNetworkAndBrandResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
