<?php

namespace TurnedAwayBOSS\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Count ServiceType
 * @subpackage Services
 */
class Count extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CountAvailableDeals
     * Meta information extracted from the WSDL
     * - documentation: Get the number of available deals ready to be collected. / Obtenir le nombre de dossiers disponibles et prêts à être collectés.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\CountAvailableDeals $parameters
     * @return \TurnedAwayBOSS\StructType\CountAvailableDealsResponse|bool
     */
    public function CountAvailableDeals(\TurnedAwayBOSS\StructType\CountAvailableDeals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountAvailableDeals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CountUpdatedDeals
     * Meta information extracted from the WSDL
     * - documentation: Get the number of updated deals ready to be collected. / Obtenir le nombre de dossiers modifiés et prêts à être collectés.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurnedAwayBOSS\StructType\CountUpdatedDeals $parameters
     * @return \TurnedAwayBOSS\StructType\CountUpdatedDealsResponse|bool
     */
    public function CountUpdatedDeals(\TurnedAwayBOSS\StructType\CountUpdatedDeals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountUpdatedDeals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurnedAwayBOSS\StructType\CountAvailableDealsResponse|\TurnedAwayBOSS\StructType\CountUpdatedDealsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
