<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPropertyExpense ArrayType
 * @subpackage Arrays
 */
class ArrayOfPropertyExpense extends AbstractStructArrayBase
{
    /**
     * The PropertyExpense
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\PropertyExpense[]
     */
    public $PropertyExpense;
    /**
     * Constructor method for ArrayOfPropertyExpense
     * @uses ArrayOfPropertyExpense::setPropertyExpense()
     * @param \TurnedAwayBOSS\StructType\PropertyExpense[] $propertyExpense
     */
    public function __construct(array $propertyExpense = array())
    {
        $this
            ->setPropertyExpense($propertyExpense);
    }
    /**
     * Get PropertyExpense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\PropertyExpense[]|null
     */
    public function getPropertyExpense()
    {
        return isset($this->PropertyExpense) ? $this->PropertyExpense : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyExpense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyExpense method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyExpenseForArrayConstraintsFromSetPropertyExpense(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPropertyExpensePropertyExpenseItem) {
            // validation for constraint: itemType
            if (!$arrayOfPropertyExpensePropertyExpenseItem instanceof \TurnedAwayBOSS\StructType\PropertyExpense) {
                $invalidValues[] = is_object($arrayOfPropertyExpensePropertyExpenseItem) ? get_class($arrayOfPropertyExpensePropertyExpenseItem) : sprintf('%s(%s)', gettype($arrayOfPropertyExpensePropertyExpenseItem), var_export($arrayOfPropertyExpensePropertyExpenseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyExpense property can only contain items of type \TurnedAwayBOSS\StructType\PropertyExpense, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyExpense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\PropertyExpense[] $propertyExpense
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense
     */
    public function setPropertyExpense(array $propertyExpense = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyExpenseArrayErrorMessage = self::validatePropertyExpenseForArrayConstraintsFromSetPropertyExpense($propertyExpense))) {
            throw new \InvalidArgumentException($propertyExpenseArrayErrorMessage, __LINE__);
        }
        if (is_null($propertyExpense) || (is_array($propertyExpense) && empty($propertyExpense))) {
            unset($this->PropertyExpense);
        } else {
            $this->PropertyExpense = $propertyExpense;
        }
        return $this;
    }
    /**
     * Add item to PropertyExpense value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\PropertyExpense $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense
     */
    public function addToPropertyExpense(\TurnedAwayBOSS\StructType\PropertyExpense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\PropertyExpense) {
            throw new \InvalidArgumentException(sprintf('The PropertyExpense property can only contain items of type \TurnedAwayBOSS\StructType\PropertyExpense, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyExpense[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\PropertyExpense|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\PropertyExpense|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\PropertyExpense|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\PropertyExpense|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\PropertyExpense|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PropertyExpense
     */
    public function getAttributeName()
    {
        return 'PropertyExpense';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfPropertyExpense
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
