<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMortgageRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfMortgageRequest extends AbstractStructArrayBase
{
    /**
     * The MortgageRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\MortgageRequest[]
     */
    public $MortgageRequest;
    /**
     * Constructor method for ArrayOfMortgageRequest
     * @uses ArrayOfMortgageRequest::setMortgageRequest()
     * @param \TurnedAwayBOSS\StructType\MortgageRequest[] $mortgageRequest
     */
    public function __construct(array $mortgageRequest = array())
    {
        $this
            ->setMortgageRequest($mortgageRequest);
    }
    /**
     * Get MortgageRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\MortgageRequest[]|null
     */
    public function getMortgageRequest()
    {
        return isset($this->MortgageRequest) ? $this->MortgageRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMortgageRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMortgageRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMortgageRequestForArrayConstraintsFromSetMortgageRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMortgageRequestMortgageRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfMortgageRequestMortgageRequestItem instanceof \TurnedAwayBOSS\StructType\MortgageRequest) {
                $invalidValues[] = is_object($arrayOfMortgageRequestMortgageRequestItem) ? get_class($arrayOfMortgageRequestMortgageRequestItem) : sprintf('%s(%s)', gettype($arrayOfMortgageRequestMortgageRequestItem), var_export($arrayOfMortgageRequestMortgageRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MortgageRequest property can only contain items of type \TurnedAwayBOSS\StructType\MortgageRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MortgageRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\MortgageRequest[] $mortgageRequest
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest
     */
    public function setMortgageRequest(array $mortgageRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($mortgageRequestArrayErrorMessage = self::validateMortgageRequestForArrayConstraintsFromSetMortgageRequest($mortgageRequest))) {
            throw new \InvalidArgumentException($mortgageRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($mortgageRequest) || (is_array($mortgageRequest) && empty($mortgageRequest))) {
            unset($this->MortgageRequest);
        } else {
            $this->MortgageRequest = $mortgageRequest;
        }
        return $this;
    }
    /**
     * Add item to MortgageRequest value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\MortgageRequest $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest
     */
    public function addToMortgageRequest(\TurnedAwayBOSS\StructType\MortgageRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\MortgageRequest) {
            throw new \InvalidArgumentException(sprintf('The MortgageRequest property can only contain items of type \TurnedAwayBOSS\StructType\MortgageRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MortgageRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\MortgageRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\MortgageRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\MortgageRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\MortgageRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\MortgageRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MortgageRequest
     */
    public function getAttributeName()
    {
        return 'MortgageRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
