<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLiability ArrayType
 * @subpackage Arrays
 */
class ArrayOfLiability extends AbstractStructArrayBase
{
    /**
     * The Liability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Liability[]
     */
    public $Liability;
    /**
     * Constructor method for ArrayOfLiability
     * @uses ArrayOfLiability::setLiability()
     * @param \TurnedAwayBOSS\StructType\Liability[] $liability
     */
    public function __construct(array $liability = array())
    {
        $this
            ->setLiability($liability);
    }
    /**
     * Get Liability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Liability[]|null
     */
    public function getLiability()
    {
        return isset($this->Liability) ? $this->Liability : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLiability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLiability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLiabilityForArrayConstraintsFromSetLiability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLiabilityLiabilityItem) {
            // validation for constraint: itemType
            if (!$arrayOfLiabilityLiabilityItem instanceof \TurnedAwayBOSS\StructType\Liability) {
                $invalidValues[] = is_object($arrayOfLiabilityLiabilityItem) ? get_class($arrayOfLiabilityLiabilityItem) : sprintf('%s(%s)', gettype($arrayOfLiabilityLiabilityItem), var_export($arrayOfLiabilityLiabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Liability property can only contain items of type \TurnedAwayBOSS\StructType\Liability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Liability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Liability[] $liability
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfLiability
     */
    public function setLiability(array $liability = array())
    {
        // validation for constraint: array
        if ('' !== ($liabilityArrayErrorMessage = self::validateLiabilityForArrayConstraintsFromSetLiability($liability))) {
            throw new \InvalidArgumentException($liabilityArrayErrorMessage, __LINE__);
        }
        if (is_null($liability) || (is_array($liability) && empty($liability))) {
            unset($this->Liability);
        } else {
            $this->Liability = $liability;
        }
        return $this;
    }
    /**
     * Add item to Liability value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Liability $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfLiability
     */
    public function addToLiability(\TurnedAwayBOSS\StructType\Liability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Liability) {
            throw new \InvalidArgumentException(sprintf('The Liability property can only contain items of type \TurnedAwayBOSS\StructType\Liability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Liability[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\Liability|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\Liability|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\Liability|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\Liability|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\Liability|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Liability
     */
    public function getAttributeName()
    {
        return 'Liability';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfLiability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
