<?php

namespace TurnedAwayBOSS\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDownPayment ArrayType
 * @subpackage Arrays
 */
class ArrayOfDownPayment extends AbstractStructArrayBase
{
    /**
     * The DownPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\DownPayment[]
     */
    public $DownPayment;
    /**
     * Constructor method for ArrayOfDownPayment
     * @uses ArrayOfDownPayment::setDownPayment()
     * @param \TurnedAwayBOSS\StructType\DownPayment[] $downPayment
     */
    public function __construct(array $downPayment = array())
    {
        $this
            ->setDownPayment($downPayment);
    }
    /**
     * Get DownPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\DownPayment[]|null
     */
    public function getDownPayment()
    {
        return isset($this->DownPayment) ? $this->DownPayment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDownPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDownPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDownPaymentForArrayConstraintsFromSetDownPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDownPaymentDownPaymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfDownPaymentDownPaymentItem instanceof \TurnedAwayBOSS\StructType\DownPayment) {
                $invalidValues[] = is_object($arrayOfDownPaymentDownPaymentItem) ? get_class($arrayOfDownPaymentDownPaymentItem) : sprintf('%s(%s)', gettype($arrayOfDownPaymentDownPaymentItem), var_export($arrayOfDownPaymentDownPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DownPayment property can only contain items of type \TurnedAwayBOSS\StructType\DownPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DownPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\DownPayment[] $downPayment
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment
     */
    public function setDownPayment(array $downPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($downPaymentArrayErrorMessage = self::validateDownPaymentForArrayConstraintsFromSetDownPayment($downPayment))) {
            throw new \InvalidArgumentException($downPaymentArrayErrorMessage, __LINE__);
        }
        if (is_null($downPayment) || (is_array($downPayment) && empty($downPayment))) {
            unset($this->DownPayment);
        } else {
            $this->DownPayment = $downPayment;
        }
        return $this;
    }
    /**
     * Add item to DownPayment value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\DownPayment $item
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment
     */
    public function addToDownPayment(\TurnedAwayBOSS\StructType\DownPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\DownPayment) {
            throw new \InvalidArgumentException(sprintf('The DownPayment property can only contain items of type \TurnedAwayBOSS\StructType\DownPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DownPayment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurnedAwayBOSS\StructType\DownPayment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurnedAwayBOSS\StructType\DownPayment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurnedAwayBOSS\StructType\DownPayment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurnedAwayBOSS\StructType\DownPayment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurnedAwayBOSS\StructType\DownPayment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DownPayment
     */
    public function getAttributeName()
    {
        return 'DownPayment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfDownPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
