<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneratorPdfBytesAuthenticatedRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: q4:GeneratorPdfBytesAuthenticatedRequestBase
 * @subpackage Structs
 */
class GeneratorPdfBytesAuthenticatedRequestBase extends AbstractStructBase
{
    /**
     * The IdApplicazione
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdApplicazione;
    /**
     * Constructor method for GeneratorPdfBytesAuthenticatedRequestBase
     * @uses GeneratorPdfBytesAuthenticatedRequestBase::setIdApplicazione()
     * @param string $idApplicazione
     */
    public function __construct($idApplicazione = null)
    {
        $this
            ->setIdApplicazione($idApplicazione);
    }
    /**
     * Get IdApplicazione value
     * @return string|null
     */
    public function getIdApplicazione()
    {
        return $this->IdApplicazione;
    }
    /**
     * Set IdApplicazione value
     * @param string $idApplicazione
     * @return \StructType\GeneratorPdfBytesAuthenticatedRequestBase
     */
    public function setIdApplicazione($idApplicazione = null)
    {
        // validation for constraint: string
        if (!is_null($idApplicazione) && !is_string($idApplicazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idApplicazione, true), gettype($idApplicazione)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($idApplicazione) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idApplicazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($idApplicazione, true)), __LINE__);
        }
        $this->IdApplicazione = $idApplicazione;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneratorPdfBytesAuthenticatedRequestBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
