<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseHeaderType StructType
 * @subpackage Structs
 */
class ResponseHeaderType extends AbstractStructBase
{
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: head:MessageID
     * @var string
     */
    public $MessageID;
    /**
     * The CorrelationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The ElapsedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:ElapsedTime
     * @var int
     */
    public $ElapsedTime;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:StatusDescription
     * @var string
     */
    public $StatusDescription;
    /**
     * The StatusDescriptionKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:StatusDescriptionKey
     * @var string
     */
    public $StatusDescriptionKey;
    /**
     * The StatusMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:StatusMessages
     * @var \StructType\StatusMessagesType
     */
    public $StatusMessages;
    /**
     * Constructor method for ResponseHeaderType
     * @uses ResponseHeaderType::setMessageID()
     * @uses ResponseHeaderType::setCorrelationID()
     * @uses ResponseHeaderType::setElapsedTime()
     * @uses ResponseHeaderType::setStatusCode()
     * @uses ResponseHeaderType::setStatusDescription()
     * @uses ResponseHeaderType::setStatusDescriptionKey()
     * @uses ResponseHeaderType::setStatusMessages()
     * @param string $messageID
     * @param string $correlationID
     * @param int $elapsedTime
     * @param string $statusCode
     * @param string $statusDescription
     * @param string $statusDescriptionKey
     * @param \StructType\StatusMessagesType $statusMessages
     */
    public function __construct($messageID = null, $correlationID = null, $elapsedTime = null, $statusCode = null, $statusDescription = null, $statusDescriptionKey = null, \StructType\StatusMessagesType $statusMessages = null)
    {
        $this
            ->setMessageID($messageID)
            ->setCorrelationID($correlationID)
            ->setElapsedTime($elapsedTime)
            ->setStatusCode($statusCode)
            ->setStatusDescription($statusDescription)
            ->setStatusDescriptionKey($statusDescriptionKey)
            ->setStatusMessages($statusMessages);
    }
    /**
     * Get MessageID value
     * @return string
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param string $messageID
     * @return \StructType\ResponseHeaderType
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageID, true), gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\ResponseHeaderType
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return int|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param int $elapsedTime
     * @return \StructType\ResponseHeaderType
     */
    public function setElapsedTime($elapsedTime = null)
    {
        // validation for constraint: int
        if (!is_null($elapsedTime) && !(is_int($elapsedTime) || ctype_digit($elapsedTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elapsedTime, true), gettype($elapsedTime)), __LINE__);
        }
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ResponseHeaderType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \StructType\ResponseHeaderType
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get StatusDescriptionKey value
     * @return string|null
     */
    public function getStatusDescriptionKey()
    {
        return $this->StatusDescriptionKey;
    }
    /**
     * Set StatusDescriptionKey value
     * @param string $statusDescriptionKey
     * @return \StructType\ResponseHeaderType
     */
    public function setStatusDescriptionKey($statusDescriptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescriptionKey) && !is_string($statusDescriptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescriptionKey, true), gettype($statusDescriptionKey)), __LINE__);
        }
        $this->StatusDescriptionKey = $statusDescriptionKey;
        return $this;
    }
    /**
     * Get StatusMessages value
     * @return \StructType\StatusMessagesType|null
     */
    public function getStatusMessages()
    {
        return $this->StatusMessages;
    }
    /**
     * Set StatusMessages value
     * @param \StructType\StatusMessagesType $statusMessages
     * @return \StructType\ResponseHeaderType
     */
    public function setStatusMessages(\StructType\StatusMessagesType $statusMessages = null)
    {
        $this->StatusMessages = $statusMessages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
