<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestHeaderType StructType
 * @subpackage Structs
 */
class RequestHeaderType extends AbstractStructBase
{
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: head:MessageID
     * @var string
     */
    public $MessageID;
    /**
     * The CreationTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:CreationTimestamp
     * @var string
     */
    public $CreationTimestamp;
    /**
     * The CorrelationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: com:CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The FaultTO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:FaultTO
     * @var string
     */
    public $FaultTO;
    /**
     * The ReplyTO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:ReplyTO
     * @var string
     */
    public $ReplyTO;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: head:Credentials
     * @var \StructType\CredentialsType
     */
    public $Credentials;
    /**
     * Constructor method for RequestHeaderType
     * @uses RequestHeaderType::setMessageID()
     * @uses RequestHeaderType::setCreationTimestamp()
     * @uses RequestHeaderType::setCorrelationID()
     * @uses RequestHeaderType::setFaultTO()
     * @uses RequestHeaderType::setReplyTO()
     * @uses RequestHeaderType::setCredentials()
     * @param string $messageID
     * @param string $creationTimestamp
     * @param string $correlationID
     * @param string $faultTO
     * @param string $replyTO
     * @param \StructType\CredentialsType $credentials
     */
    public function __construct($messageID = null, $creationTimestamp = null, $correlationID = null, $faultTO = null, $replyTO = null, \StructType\CredentialsType $credentials = null)
    {
        $this
            ->setMessageID($messageID)
            ->setCreationTimestamp($creationTimestamp)
            ->setCorrelationID($correlationID)
            ->setFaultTO($faultTO)
            ->setReplyTO($replyTO)
            ->setCredentials($credentials);
    }
    /**
     * Get MessageID value
     * @return string
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param string $messageID
     * @return \StructType\RequestHeaderType
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageID, true), gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get CreationTimestamp value
     * @return string|null
     */
    public function getCreationTimestamp()
    {
        return $this->CreationTimestamp;
    }
    /**
     * Set CreationTimestamp value
     * @param string $creationTimestamp
     * @return \StructType\RequestHeaderType
     */
    public function setCreationTimestamp($creationTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($creationTimestamp) && !is_string($creationTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationTimestamp, true), gettype($creationTimestamp)), __LINE__);
        }
        $this->CreationTimestamp = $creationTimestamp;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\RequestHeaderType
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get FaultTO value
     * @return string|null
     */
    public function getFaultTO()
    {
        return $this->FaultTO;
    }
    /**
     * Set FaultTO value
     * @param string $faultTO
     * @return \StructType\RequestHeaderType
     */
    public function setFaultTO($faultTO = null)
    {
        // validation for constraint: string
        if (!is_null($faultTO) && !is_string($faultTO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultTO, true), gettype($faultTO)), __LINE__);
        }
        $this->FaultTO = $faultTO;
        return $this;
    }
    /**
     * Get ReplyTO value
     * @return string|null
     */
    public function getReplyTO()
    {
        return $this->ReplyTO;
    }
    /**
     * Set ReplyTO value
     * @param string $replyTO
     * @return \StructType\RequestHeaderType
     */
    public function setReplyTO($replyTO = null)
    {
        // validation for constraint: string
        if (!is_null($replyTO) && !is_string($replyTO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyTO, true), gettype($replyTO)), __LINE__);
        }
        $this->ReplyTO = $replyTO;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \StructType\CredentialsType|null
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \StructType\CredentialsType $credentials
     * @return \StructType\RequestHeaderType
     */
    public function setCredentials(\StructType\CredentialsType $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
