<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuntimeContextType StructType
 * @subpackage Structs
 */
class RuntimeContextType extends AbstractStructBase
{
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - ref: tns:ServiceName
     * @var string
     */
    public $ServiceName;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - ref: tns:Application
     * @var string
     */
    public $Application;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - ref: tns:ApplicationVersion
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AppNode
     * Meta information extracted from the WSDL
     * - ref: tns:AppNode
     * @var string
     */
    public $AppNode;
    /**
     * The Hostname
     * Meta information extracted from the WSDL
     * - ref: tns:Hostname
     * @var string
     */
    public $Hostname;
    /**
     * Constructor method for RuntimeContextType
     * @uses RuntimeContextType::setServiceName()
     * @uses RuntimeContextType::setApplication()
     * @uses RuntimeContextType::setApplicationVersion()
     * @uses RuntimeContextType::setAppNode()
     * @uses RuntimeContextType::setHostname()
     * @param string $serviceName
     * @param string $application
     * @param string $applicationVersion
     * @param string $appNode
     * @param string $hostname
     */
    public function __construct($serviceName = null, $application = null, $applicationVersion = null, $appNode = null, $hostname = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setApplication($application)
            ->setApplicationVersion($applicationVersion)
            ->setAppNode($appNode)
            ->setHostname($hostname);
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \StructType\RuntimeContextType
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \StructType\RuntimeContextType
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return $this->ApplicationVersion;
    }
    /**
     * Set ApplicationVersion value
     * @param string $applicationVersion
     * @return \StructType\RuntimeContextType
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        $this->ApplicationVersion = $applicationVersion;
        return $this;
    }
    /**
     * Get AppNode value
     * @return string|null
     */
    public function getAppNode()
    {
        return $this->AppNode;
    }
    /**
     * Set AppNode value
     * @param string $appNode
     * @return \StructType\RuntimeContextType
     */
    public function setAppNode($appNode = null)
    {
        // validation for constraint: string
        if (!is_null($appNode) && !is_string($appNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appNode, true), gettype($appNode)), __LINE__);
        }
        $this->AppNode = $appNode;
        return $this;
    }
    /**
     * Get Hostname value
     * @return string|null
     */
    public function getHostname()
    {
        return $this->Hostname;
    }
    /**
     * Set Hostname value
     * @param string $hostname
     * @return \StructType\RuntimeContextType
     */
    public function setHostname($hostname = null)
    {
        // validation for constraint: string
        if (!is_null($hostname) && !is_string($hostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostname, true), gettype($hostname)), __LINE__);
        }
        $this->Hostname = $hostname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuntimeContextType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
