<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoanOffsetOutputType StructType
 * @subpackage Structs
 */
class LoanOffsetOutputType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The LoanAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoanAccount;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementAmount;
    /**
     * Constructor method for LoanOffsetOutputType
     * @uses LoanOffsetOutputType::setStatus()
     * @uses LoanOffsetOutputType::setLoanAccount()
     * @uses LoanOffsetOutputType::setSettlementAmount()
     * @param string $status
     * @param string $loanAccount
     * @param string $settlementAmount
     */
    public function __construct($status = null, $loanAccount = null, $settlementAmount = null)
    {
        $this
            ->setStatus($status)
            ->setLoanAccount($loanAccount)
            ->setSettlementAmount($settlementAmount);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\LoanOffsetOutputType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LoanAccount value
     * @return string|null
     */
    public function getLoanAccount()
    {
        return $this->LoanAccount;
    }
    /**
     * Set LoanAccount value
     * @param string $loanAccount
     * @return \StructType\LoanOffsetOutputType
     */
    public function setLoanAccount($loanAccount = null)
    {
        // validation for constraint: string
        if (!is_null($loanAccount) && !is_string($loanAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanAccount, true), gettype($loanAccount)), __LINE__);
        }
        $this->LoanAccount = $loanAccount;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return string|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param string $settlementAmount
     * @return \StructType\LoanOffsetOutputType
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        // validation for constraint: string
        if (!is_null($settlementAmount) && !is_string($settlementAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementAmount, true), gettype($settlementAmount)), __LINE__);
        }
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoanOffsetOutputType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
