<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoanOffsetInputType StructType
 * @subpackage Structs
 */
class LoanOffsetInputType extends AbstractStructBase
{
    /**
     * The LoanAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoanAccount;
    /**
     * The SettlementAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementAccount;
    /**
     * The ApplyCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplyCharges;
    /**
     * Constructor method for LoanOffsetInputType
     * @uses LoanOffsetInputType::setLoanAccount()
     * @uses LoanOffsetInputType::setSettlementAccount()
     * @uses LoanOffsetInputType::setApplyCharges()
     * @param string $loanAccount
     * @param string $settlementAccount
     * @param string $applyCharges
     */
    public function __construct($loanAccount = null, $settlementAccount = null, $applyCharges = null)
    {
        $this
            ->setLoanAccount($loanAccount)
            ->setSettlementAccount($settlementAccount)
            ->setApplyCharges($applyCharges);
    }
    /**
     * Get LoanAccount value
     * @return string
     */
    public function getLoanAccount()
    {
        return $this->LoanAccount;
    }
    /**
     * Set LoanAccount value
     * @param string $loanAccount
     * @return \StructType\LoanOffsetInputType
     */
    public function setLoanAccount($loanAccount = null)
    {
        // validation for constraint: string
        if (!is_null($loanAccount) && !is_string($loanAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanAccount, true), gettype($loanAccount)), __LINE__);
        }
        $this->LoanAccount = $loanAccount;
        return $this;
    }
    /**
     * Get SettlementAccount value
     * @return string|null
     */
    public function getSettlementAccount()
    {
        return $this->SettlementAccount;
    }
    /**
     * Set SettlementAccount value
     * @param string $settlementAccount
     * @return \StructType\LoanOffsetInputType
     */
    public function setSettlementAccount($settlementAccount = null)
    {
        // validation for constraint: string
        if (!is_null($settlementAccount) && !is_string($settlementAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementAccount, true), gettype($settlementAccount)), __LINE__);
        }
        $this->SettlementAccount = $settlementAccount;
        return $this;
    }
    /**
     * Get ApplyCharges value
     * @return string|null
     */
    public function getApplyCharges()
    {
        return $this->ApplyCharges;
    }
    /**
     * Set ApplyCharges value
     * @param string $applyCharges
     * @return \StructType\LoanOffsetInputType
     */
    public function setApplyCharges($applyCharges = null)
    {
        // validation for constraint: string
        if (!is_null($applyCharges) && !is_string($applyCharges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyCharges, true), gettype($applyCharges)), __LINE__);
        }
        $this->ApplyCharges = $applyCharges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoanOffsetInputType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
