<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultType StructType
 * @subpackage Structs
 */
class FaultType extends AbstractStructBase
{
    /**
     * The FaultHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: tns:FaultHeader
     * @var \StructType\ResponseHeaderType
     */
    public $FaultHeader;
    /**
     * The ExceptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: tns:ExceptionId
     * @var string
     */
    public $ExceptionId;
    /**
     * The ExceptionTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: tns:ExceptionTimestamp
     * @var string
     */
    public $ExceptionTimestamp;
    /**
     * The ExceptionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - ref: tns:ExceptionCode
     * @var string
     */
    public $ExceptionCode;
    /**
     * The Severity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Severity
     * @var string
     */
    public $Severity;
    /**
     * The ExceptionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:ExceptionName
     * @var string
     */
    public $ExceptionName;
    /**
     * The ExceptionDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:ExceptionDescription
     * @var string
     */
    public $ExceptionDescription;
    /**
     * The ExceptionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:ExceptionDetails
     * @var string
     */
    public $ExceptionDetails;
    /**
     * The FaultDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:FaultDetails
     * @var \StructType\FaultDetailsType
     */
    public $FaultDetails;
    /**
     * The RuntimeContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: rctx:RuntimeContext
     * @var \StructType\RuntimeContextType
     */
    public $RuntimeContext;
    /**
     * The Payload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: com:Payload
     * @var \StructType\PayloadType
     */
    public $Payload;
    /**
     * Constructor method for FaultType
     * @uses FaultType::setFaultHeader()
     * @uses FaultType::setExceptionId()
     * @uses FaultType::setExceptionTimestamp()
     * @uses FaultType::setExceptionCode()
     * @uses FaultType::setSeverity()
     * @uses FaultType::setExceptionName()
     * @uses FaultType::setExceptionDescription()
     * @uses FaultType::setExceptionDetails()
     * @uses FaultType::setFaultDetails()
     * @uses FaultType::setRuntimeContext()
     * @uses FaultType::setPayload()
     * @param \StructType\ResponseHeaderType $faultHeader
     * @param string $exceptionId
     * @param string $exceptionTimestamp
     * @param string $exceptionCode
     * @param string $severity
     * @param string $exceptionName
     * @param string $exceptionDescription
     * @param string $exceptionDetails
     * @param \StructType\FaultDetailsType $faultDetails
     * @param \StructType\RuntimeContextType $runtimeContext
     * @param \StructType\PayloadType $payload
     */
    public function __construct(\StructType\ResponseHeaderType $faultHeader = null, $exceptionId = null, $exceptionTimestamp = null, $exceptionCode = null, $severity = null, $exceptionName = null, $exceptionDescription = null, $exceptionDetails = null, \StructType\FaultDetailsType $faultDetails = null, \StructType\RuntimeContextType $runtimeContext = null, \StructType\PayloadType $payload = null)
    {
        $this
            ->setFaultHeader($faultHeader)
            ->setExceptionId($exceptionId)
            ->setExceptionTimestamp($exceptionTimestamp)
            ->setExceptionCode($exceptionCode)
            ->setSeverity($severity)
            ->setExceptionName($exceptionName)
            ->setExceptionDescription($exceptionDescription)
            ->setExceptionDetails($exceptionDetails)
            ->setFaultDetails($faultDetails)
            ->setRuntimeContext($runtimeContext)
            ->setPayload($payload);
    }
    /**
     * Get FaultHeader value
     * @return \StructType\ResponseHeaderType
     */
    public function getFaultHeader()
    {
        return $this->FaultHeader;
    }
    /**
     * Set FaultHeader value
     * @param \StructType\ResponseHeaderType $faultHeader
     * @return \StructType\FaultType
     */
    public function setFaultHeader(\StructType\ResponseHeaderType $faultHeader = null)
    {
        $this->FaultHeader = $faultHeader;
        return $this;
    }
    /**
     * Get ExceptionId value
     * @return string
     */
    public function getExceptionId()
    {
        return $this->ExceptionId;
    }
    /**
     * Set ExceptionId value
     * @param string $exceptionId
     * @return \StructType\FaultType
     */
    public function setExceptionId($exceptionId = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionId) && !is_string($exceptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionId, true), gettype($exceptionId)), __LINE__);
        }
        $this->ExceptionId = $exceptionId;
        return $this;
    }
    /**
     * Get ExceptionTimestamp value
     * @return string
     */
    public function getExceptionTimestamp()
    {
        return $this->ExceptionTimestamp;
    }
    /**
     * Set ExceptionTimestamp value
     * @param string $exceptionTimestamp
     * @return \StructType\FaultType
     */
    public function setExceptionTimestamp($exceptionTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionTimestamp) && !is_string($exceptionTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionTimestamp, true), gettype($exceptionTimestamp)), __LINE__);
        }
        $this->ExceptionTimestamp = $exceptionTimestamp;
        return $this;
    }
    /**
     * Get ExceptionCode value
     * @return string
     */
    public function getExceptionCode()
    {
        return $this->ExceptionCode;
    }
    /**
     * Set ExceptionCode value
     * @param string $exceptionCode
     * @return \StructType\FaultType
     */
    public function setExceptionCode($exceptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionCode) && !is_string($exceptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionCode, true), gettype($exceptionCode)), __LINE__);
        }
        $this->ExceptionCode = $exceptionCode;
        return $this;
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \StructType\FaultType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get ExceptionName value
     * @return string|null
     */
    public function getExceptionName()
    {
        return $this->ExceptionName;
    }
    /**
     * Set ExceptionName value
     * @param string $exceptionName
     * @return \StructType\FaultType
     */
    public function setExceptionName($exceptionName = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionName) && !is_string($exceptionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionName, true), gettype($exceptionName)), __LINE__);
        }
        $this->ExceptionName = $exceptionName;
        return $this;
    }
    /**
     * Get ExceptionDescription value
     * @return string|null
     */
    public function getExceptionDescription()
    {
        return $this->ExceptionDescription;
    }
    /**
     * Set ExceptionDescription value
     * @param string $exceptionDescription
     * @return \StructType\FaultType
     */
    public function setExceptionDescription($exceptionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionDescription) && !is_string($exceptionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionDescription, true), gettype($exceptionDescription)), __LINE__);
        }
        $this->ExceptionDescription = $exceptionDescription;
        return $this;
    }
    /**
     * Get ExceptionDetails value
     * @return string|null
     */
    public function getExceptionDetails()
    {
        return $this->ExceptionDetails;
    }
    /**
     * Set ExceptionDetails value
     * @param string $exceptionDetails
     * @return \StructType\FaultType
     */
    public function setExceptionDetails($exceptionDetails = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionDetails) && !is_string($exceptionDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionDetails, true), gettype($exceptionDetails)), __LINE__);
        }
        $this->ExceptionDetails = $exceptionDetails;
        return $this;
    }
    /**
     * Get FaultDetails value
     * @return \StructType\FaultDetailsType|null
     */
    public function getFaultDetails()
    {
        return $this->FaultDetails;
    }
    /**
     * Set FaultDetails value
     * @param \StructType\FaultDetailsType $faultDetails
     * @return \StructType\FaultType
     */
    public function setFaultDetails(\StructType\FaultDetailsType $faultDetails = null)
    {
        $this->FaultDetails = $faultDetails;
        return $this;
    }
    /**
     * Get RuntimeContext value
     * @return \StructType\RuntimeContextType|null
     */
    public function getRuntimeContext()
    {
        return $this->RuntimeContext;
    }
    /**
     * Set RuntimeContext value
     * @param \StructType\RuntimeContextType $runtimeContext
     * @return \StructType\FaultType
     */
    public function setRuntimeContext(\StructType\RuntimeContextType $runtimeContext = null)
    {
        $this->RuntimeContext = $runtimeContext;
        return $this;
    }
    /**
     * Get Payload value
     * @return \StructType\PayloadType|null
     */
    public function getPayload()
    {
        return $this->Payload;
    }
    /**
     * Set Payload value
     * @param \StructType\PayloadType $payload
     * @return \StructType\FaultType
     */
    public function setPayload(\StructType\PayloadType $payload = null)
    {
        $this->Payload = $payload;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
