<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultContextType StructType
 * @subpackage Structs
 */
class FaultContextType extends AbstractStructBase
{
    /**
     * The Hostname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Hostname
     * @var string
     */
    public $Hostname;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Application
     * @var string
     */
    public $Application;
    /**
     * The Instance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Instance
     * @var string
     */
    public $Instance;
    /**
     * Constructor method for FaultContextType
     * @uses FaultContextType::setHostname()
     * @uses FaultContextType::setApplication()
     * @uses FaultContextType::setInstance()
     * @param string $hostname
     * @param string $application
     * @param string $instance
     */
    public function __construct($hostname = null, $application = null, $instance = null)
    {
        $this
            ->setHostname($hostname)
            ->setApplication($application)
            ->setInstance($instance);
    }
    /**
     * Get Hostname value
     * @return string|null
     */
    public function getHostname()
    {
        return $this->Hostname;
    }
    /**
     * Set Hostname value
     * @param string $hostname
     * @return \StructType\FaultContextType
     */
    public function setHostname($hostname = null)
    {
        // validation for constraint: string
        if (!is_null($hostname) && !is_string($hostname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostname, true), gettype($hostname)), __LINE__);
        }
        $this->Hostname = $hostname;
        return $this;
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \StructType\FaultContextType
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \StructType\FaultContextType
     */
    public function setInstance($instance = null)
    {
        // validation for constraint: string
        if (!is_null($instance) && !is_string($instance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instance, true), gettype($instance)), __LINE__);
        }
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultContextType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
