<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Loan ServiceType
 * @subpackage Services
 */
class Loan extends AbstractSoapClientBase
{
    /**
     * Sets the RequestHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\RequestHeaderType $requestHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestHeader(\StructType\RequestHeaderType $requestHeader, $nameSpace = 'urn://co-opbank.co.ke/CommonServices/Data/Message/MessageHeader', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestHeader', $requestHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named LoanOffset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestHeader
     * - SOAPHeaderNamespaces: urn://co-opbank.co.ke/CommonServices/Data/Message/MessageHeader
     * - SOAPHeaderTypes: \StructType\RequestHeaderType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoanOffsetInputType $parameters
     * @return \StructType\LoanOffsetOutputType|bool
     */
    public function LoanOffset(\StructType\LoanOffsetInputType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoanOffset($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoanOffsetOutputType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
