<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceContext StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceContext
 * @subpackage Structs
 */
class ServiceContext extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The OrganizationalUnit
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OrganizationalUnit;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Role;
    /**
     * The LanguageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageID;
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityToken;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestID;
    /**
     * The isTesting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTesting;
    /**
     * Constructor method for ServiceContext
     * @uses ServiceContext::setUser()
     * @uses ServiceContext::setOrganizationalUnit()
     * @uses ServiceContext::setRole()
     * @uses ServiceContext::setLanguageID()
     * @uses ServiceContext::setSecurityToken()
     * @uses ServiceContext::setRequestID()
     * @uses ServiceContext::setIsTesting()
     * @param string $user
     * @param string $organizationalUnit
     * @param string $role
     * @param string $languageID
     * @param string $securityToken
     * @param string $requestID
     * @param bool $isTesting
     */
    public function __construct($user = null, $organizationalUnit = null, $role = null, $languageID = null, $securityToken = null, $requestID = null, $isTesting = null)
    {
        $this
            ->setUser($user)
            ->setOrganizationalUnit($organizationalUnit)
            ->setRole($role)
            ->setLanguageID($languageID)
            ->setSecurityToken($securityToken)
            ->setRequestID($requestID)
            ->setIsTesting($isTesting);
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ServiceContext
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get OrganizationalUnit value
     * @return string|null
     */
    public function getOrganizationalUnit()
    {
        return $this->OrganizationalUnit;
    }
    /**
     * Set OrganizationalUnit value
     * @param string $organizationalUnit
     * @return \StructType\ServiceContext
     */
    public function setOrganizationalUnit($organizationalUnit = null)
    {
        // validation for constraint: string
        if (!is_null($organizationalUnit) && !is_string($organizationalUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationalUnit, true), gettype($organizationalUnit)), __LINE__);
        }
        $this->OrganizationalUnit = $organizationalUnit;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \StructType\ServiceContext
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
    /**
     * Get LanguageID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageID()
    {
        return isset($this->LanguageID) ? $this->LanguageID : null;
    }
    /**
     * Set LanguageID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageID
     * @return \StructType\ServiceContext
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: string
        if (!is_null($languageID) && !is_string($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageID, true), gettype($languageID)), __LINE__);
        }
        if (is_null($languageID) || (is_array($languageID) && empty($languageID))) {
            unset($this->LanguageID);
        } else {
            $this->LanguageID = $languageID;
        }
        return $this;
    }
    /**
     * Get SecurityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->SecurityToken) ? $this->SecurityToken : null;
    }
    /**
     * Set SecurityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\ServiceContext
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->SecurityToken);
        } else {
            $this->SecurityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Get RequestID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestID()
    {
        return isset($this->RequestID) ? $this->RequestID : null;
    }
    /**
     * Set RequestID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestID
     * @return \StructType\ServiceContext
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        if (is_null($requestID) || (is_array($requestID) && empty($requestID))) {
            unset($this->RequestID);
        } else {
            $this->RequestID = $requestID;
        }
        return $this;
    }
    /**
     * Get isTesting value
     * @return bool|null
     */
    public function getIsTesting()
    {
        return $this->isTesting;
    }
    /**
     * Set isTesting value
     * @param bool $isTesting
     * @return \StructType\ServiceContext
     */
    public function setIsTesting($isTesting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTesting) && !is_bool($isTesting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTesting, true), gettype($isTesting)), __LINE__);
        }
        $this->isTesting = $isTesting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
