<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KargoDesiFiyat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KargoDesiFiyat
 * @subpackage Structs
 */
class KargoDesiFiyat extends AbstractStructBase
{
    /**
     * The DesiBas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DesiBas;
    /**
     * The DesiSon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DesiSon;
    /**
     * The Fiyat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fiyat;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KargoID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoID;
    /**
     * The SehirAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SehirAdi;
    /**
     * The SehirID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SehirID;
    /**
     * The SehirIci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SehirIci;
    /**
     * The UlkeAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UlkeAdi;
    /**
     * The UlkeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UlkeID;
    /**
     * Constructor method for KargoDesiFiyat
     * @uses KargoDesiFiyat::setDesiBas()
     * @uses KargoDesiFiyat::setDesiSon()
     * @uses KargoDesiFiyat::setFiyat()
     * @uses KargoDesiFiyat::setID()
     * @uses KargoDesiFiyat::setKargoID()
     * @uses KargoDesiFiyat::setSehirAdi()
     * @uses KargoDesiFiyat::setSehirID()
     * @uses KargoDesiFiyat::setSehirIci()
     * @uses KargoDesiFiyat::setUlkeAdi()
     * @uses KargoDesiFiyat::setUlkeID()
     * @param float $desiBas
     * @param float $desiSon
     * @param float $fiyat
     * @param int $iD
     * @param int $kargoID
     * @param string $sehirAdi
     * @param int $sehirID
     * @param bool $sehirIci
     * @param string $ulkeAdi
     * @param int $ulkeID
     */
    public function __construct($desiBas = null, $desiSon = null, $fiyat = null, $iD = null, $kargoID = null, $sehirAdi = null, $sehirID = null, $sehirIci = null, $ulkeAdi = null, $ulkeID = null)
    {
        $this
            ->setDesiBas($desiBas)
            ->setDesiSon($desiSon)
            ->setFiyat($fiyat)
            ->setID($iD)
            ->setKargoID($kargoID)
            ->setSehirAdi($sehirAdi)
            ->setSehirID($sehirID)
            ->setSehirIci($sehirIci)
            ->setUlkeAdi($ulkeAdi)
            ->setUlkeID($ulkeID);
    }
    /**
     * Get DesiBas value
     * @return float|null
     */
    public function getDesiBas()
    {
        return $this->DesiBas;
    }
    /**
     * Set DesiBas value
     * @param float $desiBas
     * @return \StructType\KargoDesiFiyat
     */
    public function setDesiBas($desiBas = null)
    {
        // validation for constraint: float
        if (!is_null($desiBas) && !(is_float($desiBas) || is_numeric($desiBas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desiBas, true), gettype($desiBas)), __LINE__);
        }
        $this->DesiBas = $desiBas;
        return $this;
    }
    /**
     * Get DesiSon value
     * @return float|null
     */
    public function getDesiSon()
    {
        return $this->DesiSon;
    }
    /**
     * Set DesiSon value
     * @param float $desiSon
     * @return \StructType\KargoDesiFiyat
     */
    public function setDesiSon($desiSon = null)
    {
        // validation for constraint: float
        if (!is_null($desiSon) && !(is_float($desiSon) || is_numeric($desiSon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desiSon, true), gettype($desiSon)), __LINE__);
        }
        $this->DesiSon = $desiSon;
        return $this;
    }
    /**
     * Get Fiyat value
     * @return float|null
     */
    public function getFiyat()
    {
        return $this->Fiyat;
    }
    /**
     * Set Fiyat value
     * @param float $fiyat
     * @return \StructType\KargoDesiFiyat
     */
    public function setFiyat($fiyat = null)
    {
        // validation for constraint: float
        if (!is_null($fiyat) && !(is_float($fiyat) || is_numeric($fiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fiyat, true), gettype($fiyat)), __LINE__);
        }
        $this->Fiyat = $fiyat;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\KargoDesiFiyat
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KargoID value
     * @return int|null
     */
    public function getKargoID()
    {
        return $this->KargoID;
    }
    /**
     * Set KargoID value
     * @param int $kargoID
     * @return \StructType\KargoDesiFiyat
     */
    public function setKargoID($kargoID = null)
    {
        // validation for constraint: int
        if (!is_null($kargoID) && !(is_int($kargoID) || ctype_digit($kargoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoID, true), gettype($kargoID)), __LINE__);
        }
        $this->KargoID = $kargoID;
        return $this;
    }
    /**
     * Get SehirAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSehirAdi()
    {
        return isset($this->SehirAdi) ? $this->SehirAdi : null;
    }
    /**
     * Set SehirAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sehirAdi
     * @return \StructType\KargoDesiFiyat
     */
    public function setSehirAdi($sehirAdi = null)
    {
        // validation for constraint: string
        if (!is_null($sehirAdi) && !is_string($sehirAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sehirAdi, true), gettype($sehirAdi)), __LINE__);
        }
        if (is_null($sehirAdi) || (is_array($sehirAdi) && empty($sehirAdi))) {
            unset($this->SehirAdi);
        } else {
            $this->SehirAdi = $sehirAdi;
        }
        return $this;
    }
    /**
     * Get SehirID value
     * @return int|null
     */
    public function getSehirID()
    {
        return $this->SehirID;
    }
    /**
     * Set SehirID value
     * @param int $sehirID
     * @return \StructType\KargoDesiFiyat
     */
    public function setSehirID($sehirID = null)
    {
        // validation for constraint: int
        if (!is_null($sehirID) && !(is_int($sehirID) || ctype_digit($sehirID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sehirID, true), gettype($sehirID)), __LINE__);
        }
        $this->SehirID = $sehirID;
        return $this;
    }
    /**
     * Get SehirIci value
     * @return bool|null
     */
    public function getSehirIci()
    {
        return $this->SehirIci;
    }
    /**
     * Set SehirIci value
     * @param bool $sehirIci
     * @return \StructType\KargoDesiFiyat
     */
    public function setSehirIci($sehirIci = null)
    {
        // validation for constraint: boolean
        if (!is_null($sehirIci) && !is_bool($sehirIci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sehirIci, true), gettype($sehirIci)), __LINE__);
        }
        $this->SehirIci = $sehirIci;
        return $this;
    }
    /**
     * Get UlkeAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUlkeAdi()
    {
        return isset($this->UlkeAdi) ? $this->UlkeAdi : null;
    }
    /**
     * Set UlkeAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ulkeAdi
     * @return \StructType\KargoDesiFiyat
     */
    public function setUlkeAdi($ulkeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ulkeAdi) && !is_string($ulkeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulkeAdi, true), gettype($ulkeAdi)), __LINE__);
        }
        if (is_null($ulkeAdi) || (is_array($ulkeAdi) && empty($ulkeAdi))) {
            unset($this->UlkeAdi);
        } else {
            $this->UlkeAdi = $ulkeAdi;
        }
        return $this;
    }
    /**
     * Get UlkeID value
     * @return int|null
     */
    public function getUlkeID()
    {
        return $this->UlkeID;
    }
    /**
     * Set UlkeID value
     * @param int $ulkeID
     * @return \StructType\KargoDesiFiyat
     */
    public function setUlkeID($ulkeID = null)
    {
        // validation for constraint: int
        if (!is_null($ulkeID) && !(is_int($ulkeID) || ctype_digit($ulkeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ulkeID, true), gettype($ulkeID)), __LINE__);
        }
        $this->UlkeID = $ulkeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KargoDesiFiyat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
