<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MailList
 * @subpackage Structs
 */
class MailList extends AbstractStructBase
{
    /**
     * The EklemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklemeTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mail;
    /**
     * Constructor method for MailList
     * @uses MailList::setEklemeTarihi()
     * @uses MailList::setID()
     * @uses MailList::setMail()
     * @param string $eklemeTarihi
     * @param int $iD
     * @param string $mail
     */
    public function __construct($eklemeTarihi = null, $iD = null, $mail = null)
    {
        $this
            ->setEklemeTarihi($eklemeTarihi)
            ->setID($iD)
            ->setMail($mail);
    }
    /**
     * Get EklemeTarihi value
     * @return string|null
     */
    public function getEklemeTarihi()
    {
        return $this->EklemeTarihi;
    }
    /**
     * Set EklemeTarihi value
     * @param string $eklemeTarihi
     * @return \StructType\MailList
     */
    public function setEklemeTarihi($eklemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihi) && !is_string($eklemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihi, true), gettype($eklemeTarihi)), __LINE__);
        }
        $this->EklemeTarihi = $eklemeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\MailList
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMail()
    {
        return isset($this->Mail) ? $this->Mail : null;
    }
    /**
     * Set Mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mail
     * @return \StructType\MailList
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        if (is_null($mail) || (is_array($mail) && empty($mail))) {
            unset($this->Mail);
        } else {
            $this->Mail = $mail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
