<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveEntegrasyonId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveEntegrasyonId $parameters
     * @return \StructType\SaveEntegrasyonIdResponse|bool
     */
    public function SaveEntegrasyonId(\StructType\SaveEntegrasyonId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveEntegrasyonId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMenu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMenu $parameters
     * @return \StructType\SaveMenuResponse|bool
     */
    public function SaveMenu(\StructType\SaveMenu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMenu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSupportTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSupportTicket $parameters
     * @return \StructType\SaveSupportTicketResponse|bool
     */
    public function SaveSupportTicket(\StructType\SaveSupportTicket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSupportTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSupportTicketAnswer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSupportTicketAnswer $parameters
     * @return \StructType\SaveSupportTicketAnswerResponse|bool
     */
    public function SaveSupportTicketAnswer(\StructType\SaveSupportTicketAnswer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSupportTicketAnswer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveEntegrasyonIdResponse|\StructType\SaveMenuResponse|\StructType\SaveSupportTicketAnswerResponse|\StructType\SaveSupportTicketResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
