<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KargoIl StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KargoIl
 * @subpackage Structs
 */
class KargoIl extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The UlkeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UlkeID;
    /**
     * Constructor method for KargoIl
     * @uses KargoIl::setID()
     * @uses KargoIl::setTanim()
     * @uses KargoIl::setUlkeID()
     * @param int $iD
     * @param string $tanim
     * @param int $ulkeID
     */
    public function __construct($iD = null, $tanim = null, $ulkeID = null)
    {
        $this
            ->setID($iD)
            ->setTanim($tanim)
            ->setUlkeID($ulkeID);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\KargoIl
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\KargoIl
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get UlkeID value
     * @return int|null
     */
    public function getUlkeID()
    {
        return $this->UlkeID;
    }
    /**
     * Set UlkeID value
     * @param int $ulkeID
     * @return \StructType\KargoIl
     */
    public function setUlkeID($ulkeID = null)
    {
        // validation for constraint: int
        if (!is_null($ulkeID) && !(is_int($ulkeID) || ctype_digit($ulkeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ulkeID, true), gettype($ulkeID)), __LINE__);
        }
        $this->UlkeID = $ulkeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KargoIl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
