<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tValAnotación StructType
 * Meta information extracted from the WSDL
 * - documentation: Describe un valor individual de anotación
 * @subpackage Structs
 */
class TValAnotación extends AbstractStructBase
{
    /**
     * The Per
     * Meta information extracted from the WSDL
     * - documentation: Secuencial dentro del Intervalo. Indica el periodo horario dentro del día. No se incluiyen para aquellos periodos que no tienen anotaciones.
     * @var \StructType\TPeriodo
     */
    public $Per;
    /**
     * The Magnitud
     * Meta information extracted from the WSDL
     * - documentation: Magnitud de Energía
     * @var \StructType\TCantidad
     */
    public $Magnitud;
    /**
     * The Precio
     * Meta information extracted from the WSDL
     * - documentation: Precio aplicado a la magnitud
     * @var \StructType\TPrecioNegativo
     */
    public $Precio;
    /**
     * The Importe
     * Meta information extracted from the WSDL
     * - documentation: Importe aplicado
     * @var \StructType\TImporte
     */
    public $Importe;
    /**
     * The Segmento
     * Meta information extracted from the WSDL
     * - documentation: Código de Segmento del Mercado
     * @var \StructType\TSegmento
     */
    public $Segmento;
    /**
     * The Cuenta
     * Meta information extracted from the WSDL
     * - documentation: Código de cuenta de compensación
     * @var \StructType\TCuenta
     */
    public $Cuenta;
    /**
     * The SignoImp
     * Meta information extracted from the WSDL
     * - documentation: Signo del importe
     * @var \StructType\TSignoImp
     */
    public $SignoImp;
    /**
     * The SignoEne
     * Meta information extracted from the WSDL
     * - documentation: Signo de la energía
     * @var \StructType\TSignoEne
     */
    public $SignoEne;
    /**
     * The CodMagnitud
     * Meta information extracted from the WSDL
     * - documentation: Código que identifica la magnitud
     * @var \StructType\TCodigo
     */
    public $CodMagnitud;
    /**
     * The CodPrecio
     * Meta information extracted from the WSDL
     * - documentation: Código que identifica el precio aplicado
     * @var \StructType\TCodigo
     */
    public $CodPrecio;
    /**
     * The CodConcepto
     * Meta information extracted from the WSDL
     * - documentation: Código que identifica la anotación
     * @var \StructType\TCodigo
     */
    public $CodConcepto;
    /**
     * The SesionAnotaciones
     * Meta information extracted from the WSDL
     * - documentation: Número de sesión de intradiario
     * @var \StructType\TSesionAnotaciones
     */
    public $SesionAnotaciones;
    /**
     * Constructor method for tValAnotación
     * @uses TValAnotación::setPer()
     * @uses TValAnotación::setMagnitud()
     * @uses TValAnotación::setPrecio()
     * @uses TValAnotación::setImporte()
     * @uses TValAnotación::setSegmento()
     * @uses TValAnotación::setCuenta()
     * @uses TValAnotación::setSignoImp()
     * @uses TValAnotación::setSignoEne()
     * @uses TValAnotación::setCodMagnitud()
     * @uses TValAnotación::setCodPrecio()
     * @uses TValAnotación::setCodConcepto()
     * @uses TValAnotación::setSesionAnotaciones()
     * @param \StructType\TPeriodo $per
     * @param \StructType\TCantidad $magnitud
     * @param \StructType\TPrecioNegativo $precio
     * @param \StructType\TImporte $importe
     * @param \StructType\TSegmento $segmento
     * @param \StructType\TCuenta $cuenta
     * @param \StructType\TSignoImp $signoImp
     * @param \StructType\TSignoEne $signoEne
     * @param \StructType\TCodigo $codMagnitud
     * @param \StructType\TCodigo $codPrecio
     * @param \StructType\TCodigo $codConcepto
     * @param \StructType\TSesionAnotaciones $sesionAnotaciones
     */
    public function __construct(\StructType\TPeriodo $per = null, \StructType\TCantidad $magnitud = null, \StructType\TPrecioNegativo $precio = null, \StructType\TImporte $importe = null, \StructType\TSegmento $segmento = null, \StructType\TCuenta $cuenta = null, \StructType\TSignoImp $signoImp = null, \StructType\TSignoEne $signoEne = null, \StructType\TCodigo $codMagnitud = null, \StructType\TCodigo $codPrecio = null, \StructType\TCodigo $codConcepto = null, \StructType\TSesionAnotaciones $sesionAnotaciones = null)
    {
        $this
            ->setPer($per)
            ->setMagnitud($magnitud)
            ->setPrecio($precio)
            ->setImporte($importe)
            ->setSegmento($segmento)
            ->setCuenta($cuenta)
            ->setSignoImp($signoImp)
            ->setSignoEne($signoEne)
            ->setCodMagnitud($codMagnitud)
            ->setCodPrecio($codPrecio)
            ->setCodConcepto($codConcepto)
            ->setSesionAnotaciones($sesionAnotaciones);
    }
    /**
     * Get Per value
     * @return \StructType\TPeriodo|null
     */
    public function getPer()
    {
        return $this->Per;
    }
    /**
     * Set Per value
     * @param \StructType\TPeriodo $per
     * @return \StructType\TValAnotación
     */
    public function setPer(\StructType\TPeriodo $per = null)
    {
        $this->Per = $per;
        return $this;
    }
    /**
     * Get Magnitud value
     * @return \StructType\TCantidad|null
     */
    public function getMagnitud()
    {
        return $this->Magnitud;
    }
    /**
     * Set Magnitud value
     * @param \StructType\TCantidad $magnitud
     * @return \StructType\TValAnotación
     */
    public function setMagnitud(\StructType\TCantidad $magnitud = null)
    {
        $this->Magnitud = $magnitud;
        return $this;
    }
    /**
     * Get Precio value
     * @return \StructType\TPrecioNegativo|null
     */
    public function getPrecio()
    {
        return $this->Precio;
    }
    /**
     * Set Precio value
     * @param \StructType\TPrecioNegativo $precio
     * @return \StructType\TValAnotación
     */
    public function setPrecio(\StructType\TPrecioNegativo $precio = null)
    {
        $this->Precio = $precio;
        return $this;
    }
    /**
     * Get Importe value
     * @return \StructType\TImporte|null
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param \StructType\TImporte $importe
     * @return \StructType\TValAnotación
     */
    public function setImporte(\StructType\TImporte $importe = null)
    {
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get Segmento value
     * @return \StructType\TSegmento|null
     */
    public function getSegmento()
    {
        return $this->Segmento;
    }
    /**
     * Set Segmento value
     * @param \StructType\TSegmento $segmento
     * @return \StructType\TValAnotación
     */
    public function setSegmento(\StructType\TSegmento $segmento = null)
    {
        $this->Segmento = $segmento;
        return $this;
    }
    /**
     * Get Cuenta value
     * @return \StructType\TCuenta|null
     */
    public function getCuenta()
    {
        return $this->Cuenta;
    }
    /**
     * Set Cuenta value
     * @param \StructType\TCuenta $cuenta
     * @return \StructType\TValAnotación
     */
    public function setCuenta(\StructType\TCuenta $cuenta = null)
    {
        $this->Cuenta = $cuenta;
        return $this;
    }
    /**
     * Get SignoImp value
     * @return \StructType\TSignoImp|null
     */
    public function getSignoImp()
    {
        return $this->SignoImp;
    }
    /**
     * Set SignoImp value
     * @param \StructType\TSignoImp $signoImp
     * @return \StructType\TValAnotación
     */
    public function setSignoImp(\StructType\TSignoImp $signoImp = null)
    {
        $this->SignoImp = $signoImp;
        return $this;
    }
    /**
     * Get SignoEne value
     * @return \StructType\TSignoEne|null
     */
    public function getSignoEne()
    {
        return $this->SignoEne;
    }
    /**
     * Set SignoEne value
     * @param \StructType\TSignoEne $signoEne
     * @return \StructType\TValAnotación
     */
    public function setSignoEne(\StructType\TSignoEne $signoEne = null)
    {
        $this->SignoEne = $signoEne;
        return $this;
    }
    /**
     * Get CodMagnitud value
     * @return \StructType\TCodigo|null
     */
    public function getCodMagnitud()
    {
        return $this->CodMagnitud;
    }
    /**
     * Set CodMagnitud value
     * @param \StructType\TCodigo $codMagnitud
     * @return \StructType\TValAnotación
     */
    public function setCodMagnitud(\StructType\TCodigo $codMagnitud = null)
    {
        $this->CodMagnitud = $codMagnitud;
        return $this;
    }
    /**
     * Get CodPrecio value
     * @return \StructType\TCodigo|null
     */
    public function getCodPrecio()
    {
        return $this->CodPrecio;
    }
    /**
     * Set CodPrecio value
     * @param \StructType\TCodigo $codPrecio
     * @return \StructType\TValAnotación
     */
    public function setCodPrecio(\StructType\TCodigo $codPrecio = null)
    {
        $this->CodPrecio = $codPrecio;
        return $this;
    }
    /**
     * Get CodConcepto value
     * @return \StructType\TCodigo|null
     */
    public function getCodConcepto()
    {
        return $this->CodConcepto;
    }
    /**
     * Set CodConcepto value
     * @param \StructType\TCodigo $codConcepto
     * @return \StructType\TValAnotación
     */
    public function setCodConcepto(\StructType\TCodigo $codConcepto = null)
    {
        $this->CodConcepto = $codConcepto;
        return $this;
    }
    /**
     * Get SesionAnotaciones value
     * @return \StructType\TSesionAnotaciones|null
     */
    public function getSesionAnotaciones()
    {
        return $this->SesionAnotaciones;
    }
    /**
     * Set SesionAnotaciones value
     * @param \StructType\TSesionAnotaciones $sesionAnotaciones
     * @return \StructType\TValAnotación
     */
    public function setSesionAnotaciones(\StructType\TSesionAnotaciones $sesionAnotaciones = null)
    {
        $this->SesionAnotaciones = $sesionAnotaciones;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TValAnotación
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
